package com.yidianling.home.ui.view

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.RelativeLayout
import androidx.viewpager.widget.ViewPager
import com.yidianling.home.R
import com.yidianling.home.adapter.HomeCategoryAdapter
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeHeaderBean
import com.yidianling.common.tools.RxImageTool
import kotlinx.android.synthetic.ydl.home_category_container.view.*


/**
 * created by HaoRui
 * des: 首页分类Pager包装类
 */
class HomeCategoryContainer(private val mContext: Context, private var homeEvent: IHomeBaseEvent?) : RelativeLayout(mContext), ViewPager.OnPageChangeListener {

    private var mHomeCategoryAdapter: HomeCategoryAdapter? = null
    private var indicatorImages: MutableList<ImageView>? = ArrayList()

    private var mIndicatorSelectedResId = R.drawable.home_category_tip_select
    private var mIndicatorUnselectedResId = R.drawable.home_category_tip_unselect

    private var lastPosition = 0
    private var count = 0
    private var mIndicatorWidth: Int = RxImageTool.dip2px(9f)
    private var mIndicatorHeight: Int = RxImageTool.dip2px(5f)
    private var dp2 : Int = 0

    companion object {
         var  PAGE_ITEM_SIZE:Int = 10
    }

    init {
        initView()
        dp2 = RxImageTool.dip2px(4f)
    }

    private fun initView() {
        View.inflate(mContext, R.layout.home_category_container, this)
        initViewPager()
    }

    /**
     * 填充数据
     */
    fun initData(bean: HomeHeaderBean?) {
        mHomeCategoryAdapter?.updateItems(bean?.askCategoryData)
        if (bean?.askCategoryData?.size!! > PAGE_ITEM_SIZE){
            count = Math.ceil(Math.ceil(bean.askCategoryData?.size?.toFloat()?.div(PAGE_ITEM_SIZE.toFloat())?.toDouble()!!)).toInt()
            createIndicator()
            val params = RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,RxImageTool.dip2px(153f))
            vp_category.layoutParams = params
        }else{
            val params = RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,RxImageTool.dip2px(143f))
            vp_category.layoutParams = params
            ll_Indicator.visibility = View.GONE
        }
    }

    private fun initViewPager() {
        if (null == mHomeCategoryAdapter) {
            mHomeCategoryAdapter = HomeCategoryAdapter(context, homeEvent)
            vp_category.adapter = mHomeCategoryAdapter
        }
    }

    private fun createIndicator() {
        vp_category.addOnPageChangeListener(this)
        indicatorImages?.clear()
        ll_Indicator.visibility = visibility
        ll_Indicator.removeAllViews()
        for (i in 0 until count) {
            val imageView = ImageView(context)
            val params: LinearLayout.LayoutParams = LinearLayout.LayoutParams(mIndicatorWidth, mIndicatorHeight)
            params.rightMargin = dp2
            if (i == 0) {
                imageView.setImageResource(mIndicatorSelectedResId)
            } else {
                imageView.setImageResource(mIndicatorUnselectedResId)
            }
            indicatorImages?.add(imageView)
            ll_Indicator.addView(imageView, params)
        }
    }

    override fun onPageScrollStateChanged(state: Int) {

    }

    override fun onPageScrolled(position: Int, positionOffset: Float, positionOffsetPixels: Int) {

    }

    override fun onPageSelected(position: Int) {
        indicatorImages?.get(lastPosition)?.setImageResource(mIndicatorUnselectedResId)
        indicatorImages?.get(position)?.setImageResource(mIndicatorSelectedResId)
        lastPosition = position
    }
}