package com.yidianling.home.ui.view

import android.content.Context
import android.graphics.Typeface
import android.os.Build
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.TextView
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.RecyclerView
import com.google.android.material.tabs.TabLayout
import com.yidianling.common.tools.LogUtil
import com.yidianling.home.R
import com.yidianling.home.constract.HomeViewConfig
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeConfideBean
import com.yidianling.home.model.bean.HomeHeaderBean
import kotlinx.android.synthetic.ydl.home_confide_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 倾诉*排解模块
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/13
 */
class HomeConfideView(private val mContext: Context, private var homeEvent: IHomeBaseEvent?) : LinearLayout(mContext) {
    private var mLastPosition: Int = 0
    /**
     * 专家信息view缓存list
     */
    private var cacheInfoViewList: ArrayList<HomeConfideExpertInfoView>? = null
    /**
     * TabLayout.OnTabSelectedListener
     */
    private var listener: ConfideExpertTabSelectedListener? = null

    init {
        initView()
    }

    private fun initView() {
        val params = RecyclerView.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        layoutParams = params
        orientation = VERTICAL
        View.inflate(mContext, R.layout.home_confide_view, this)
        homeModuleConfideViewHomeCommonTitleView.setTitle(HomeViewConfig.getOrder().confideTitle)
        homeModuleConfideViewHomeCommonTitleView.setOnClickListener {
            homeEvent?.confideMoreClick()
        }
    }

    /**
     * 创建tab栏
     * @param lastPosition 上次选中的下标
     */
    fun setTitle(list: List<HomeHeaderBean.ListenCategoryDateBean>?, lastPosition: Int) {
        if (list == null || list.isEmpty()) {
            visibility = View.GONE
            return
        }
        if (listener != null) {
            tab_layout.removeOnTabSelectedListener(listener!!)
        }
        mLastPosition = lastPosition
        tab_layout.removeAllTabs()
        for ((index, bean) in list.withIndex()) {
            tab_layout.addTab(tab_layout.newTab().setText(bean.name), index == lastPosition)
        }
        listener = ConfideExpertTabSelectedListener(list, tab_layout)
        tab_layout.addOnTabSelectedListener(listener!!)
        var textView = ((tab_layout!!.getChildAt(0) as LinearLayout).getChildAt(lastPosition) as LinearLayout).getChildAt(1)
        if (textView != null && textView is TextView) {
            textView.textSize = 17f
            textView.setTextColor(ContextCompat.getColor(mContext, R.color.platform_color_242424))
            textView.typeface = Typeface.defaultFromStyle(Typeface.BOLD)
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            tab_layout.setOnScrollChangeListener { v, scrollX, scrollY, oldScrollX, oldScrollY ->
                LogUtil.e("scrollX=$scrollX")
                LogUtil.e("oldScrollX=$oldScrollX")
            }
        }
    }

    /**
     * 设置数据
     */
    fun setConfideExpertInfoView(list: List<HomeConfideBean.BodyBean>?) {
        if (list == null || list.isEmpty()) {
            ll_content.visibility = View.GONE
            return
        }
        ll_content.visibility = View.VISIBLE
        ll_content.removeAllViews()
        if (cacheInfoViewList == null) {
            cacheInfoViewList = ArrayList()
        }

        //创建HomeConfideExpertInfoView：每个tab最多显示三个专家
        if (cacheInfoViewList!!.size >= list.size) {
            for (index in 0 until list!!.size) {
                //设置数据
                cacheInfoViewList!![index].setData(list[index]!!, index, index == list!!.size - 1)
                //添加到布局
                ll_content.addView(cacheInfoViewList!![index])
            }
        } else {
            for (index in 0 until list!!.size) {
                if (index > 2) {
                    //只取前三条数据
                    break
                }
                //数据大于缓存view数量，创建view
                if (index > cacheInfoViewList!!.size - 1) {
                    var homeConfideExpertInfoView = createExpertInfoView()
                    cacheInfoViewList!!.add(homeConfideExpertInfoView)
                }
                //设置数据
                cacheInfoViewList!![index].setData(list[index], index, index == list!!.size - 1)
                //添加到布局
                ll_content.addView(cacheInfoViewList!![index])
            }
        }
    }

    /**
     * 创建专家信息view
     */
    private fun createExpertInfoView(): HomeConfideExpertInfoView {
        return HomeConfideExpertInfoView(mContext, homeEvent)
    }


    inner class ConfideExpertTabSelectedListener : TabLayout.OnTabSelectedListener {
        private var list: List<HomeHeaderBean.ListenCategoryDateBean>? = null
        private var tabLayout: TabLayout? = null

        constructor(list: List<HomeHeaderBean.ListenCategoryDateBean>, tabLayout: TabLayout) {
            this.list = list
            this.tabLayout = tabLayout
        }

        override fun onTabReselected(tab: TabLayout.Tab?) {
        }

        override fun onTabUnselected(tab: TabLayout.Tab?) {
            var textView = ((tabLayout!!.getChildAt(0) as LinearLayout).getChildAt(tab!!.position) as LinearLayout).getChildAt(1)
            if (textView != null && textView is TextView) {
                textView.textSize = 15f
                textView.setTextColor(ContextCompat.getColor(mContext, R.color.platform_color_333333))
            }
        }

        override fun onTabSelected(tab: TabLayout.Tab?) {
            if (mLastPosition == tab!!.position){
                return
            }
            var textView = ((tabLayout!!.getChildAt(0) as LinearLayout).getChildAt(tab.position) as LinearLayout).getChildAt(1)
            if (textView != null && textView is TextView) {
                textView.textSize = 17f
                textView.setTextColor(ContextCompat.getColor(mContext, R.color.platform_color_242424))
                textView.typeface = Typeface.defaultFromStyle(Typeface.BOLD)
            }

            homeEvent!!.getConfideData(list!![tab.position], tab.position)
        }
    }
}
