package com.yidianling.home.ui.view

import android.annotation.SuppressLint
import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import androidx.recyclerview.widget.RecyclerView
import com.google.gson.Gson
import com.yidianling.home.R
import com.yidianling.home.constract.HomeViewConfig
import com.yidianling.home.event.IHomeEvent
import com.yidianling.home.model.bean.MuseModuleBean
import kotlinx.android.synthetic.ydl.home_muse_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 冥想模块
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/09/10
 */
class HomeMuseView(private val mContext: Context, private var homeEvent: IHomeEvent?) :
    LinearLayout(mContext) {

    private var cacheList: ArrayList<HomeMuseView> = ArrayList()

    init {
        initView()
    }

    @SuppressLint("RestrictedApi")
    private fun initView() {
        orientation = VERTICAL
        val params = RecyclerView.LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        )
        layoutParams = params
        View.inflate(mContext, R.layout.home_muse_view, this)
        homeModuleMuseViewHomeCommonTitleView.setTitle(HomeViewConfig.getOrder().museTitle)
    }

    fun initData(bean: MuseModuleBean?) {

        if (null != bean) {

            var dataJson = Gson().toJson(bean)
            homeModuleMuseViewHomeCommonTitleView.setOnClickListener {
                homeEvent?.museMoreClick(Gson().toJson(bean))
            }

            if (null != bean.muses) {
                if (bean.muses?.size!! > 0) {
                    muse_first.setOnClickListener {
                        homeEvent?.museClick(bean.muses!![0].audioUrl, dataJson)
                    }
                }
                if (bean.muses?.size!! > 1) {
                    muse_second.setOnClickListener {
                        homeEvent?.museClick(bean.muses!![1].audioUrl, dataJson)
                    }
                }
                if (bean.muses?.size!! > 2) {
                    muse_third.setOnClickListener {
                        homeEvent?.museClick(bean.muses!![2].audioUrl, dataJson)
                    }
                }
                if (bean.muses?.size!! > 3) {
                    muse_forth.setOnClickListener {
                        homeEvent?.museClick(bean.muses!![3].audioUrl, dataJson)
                    }
                }
            }
            if (null != bean.sleeps) {
                if (bean.sleeps?.size!! > 0) {
                    sleeps_first.setOnClickListener {
                        homeEvent?.museClick(bean.sleeps!![0].audioUrl, dataJson)
                    }
                }
                if (bean.sleeps?.size!! > 1) {
                    sleeps_second.setOnClickListener {
                        homeEvent?.museClick(bean.sleeps!![1].audioUrl, dataJson)
                    }
                }
                if (bean.sleeps?.size!! > 2) {
                    sleeps_third.setOnClickListener {
                        homeEvent?.museClick(bean.sleeps!![2].audioUrl, dataJson)
                    }
                }
                if (bean.sleeps?.size!! > 3) {
                    sleeps_forth.setOnClickListener {
                        homeEvent?.museClick(bean.sleeps!![3].audioUrl, dataJson)
                    }
                }
            }
        }
    }

}