package com.yidianling.home.ui.view

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import android.widget.RelativeLayout
import com.ydl.ydlcommon.utils.YdlBuryPointUtil
import com.ydl.ydlcommon.view.banner.GlideImageLoader
import com.yidianling.home.R
import com.yidianling.home.event.IHomeBaseEvent
import com.yidianling.home.model.bean.HomeHeaderBean
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.common.tools.RxImageTool
import kotlinx.android.synthetic.ydl.home_pager_banner_view.view.*


/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述:顶部ViewPager与分类模块
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/02/13
 */
class HomePagerBannerView(private val mContext: Context, private var homeEvent: IHomeBaseEvent?) : RelativeLayout(mContext) {

    private val mImageViews = ArrayList<String>()
    private var homePagerBannerCategoryView: HomePagerBannerCategoryItemView? = null
    //实时测评数据View
    private var realTestView: HomePagerBannerRealView? = null
    private var pageContainer: HomeCategoryContainer? = null

    init {
        initView()
    }

    private fun initView() {
        var screenWidth = RxDeviceTool.getScreenWidth(mContext)
        val params = RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        layoutParams = params
        View.inflate(mContext, R.layout.home_pager_banner_view, this)

        initBannerLayout()
//        val addLayoutParams = RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
//        addLayoutParams.setMargins(0, (ScreenUtil.screenWidth * (356f / 750f)).toInt(),0,0)
//        homeModulePagerBannerViewAddLayout.layoutParams = addLayoutParams
        initPageContainer()
        initRealTextView()
    }

    private fun initPageContainer() {
        if (null == pageContainer) {
            var containerParam = FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
            pageContainer = HomeCategoryContainer(context, homeEvent!!)
            pageContainer!!.layoutParams = containerParam
            homeModulePagerBannerViewAddLayout.addView(pageContainer)
        }
    }

    private fun initBannerLayout() {
        val screenWidth = RxDeviceTool.getScreenWidth(mContext)
        val viewHeight = screenWidth * 508 / 750
        val params = RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, viewHeight)
        homeModulePagerBannerViewBanner.layoutParams = params
        homeModulePagerBannerViewBanner.setIndicatorBottomPadding(68)

        initHomeModulePagerBannerViewAddLayout(viewHeight)
    }

    private fun initHomeModulePagerBannerViewAddLayout(viewHeight : Int){
        val params = RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,ViewGroup.LayoutParams.WRAP_CONTENT)
        params.setMargins(0,(viewHeight * 0.76).toInt(),0,0)
        homeModulePagerBannerViewAddLayout.layoutParams = params
        homeModulePagerBannerViewAddLayout.setPadding(0,RxImageTool.dip2px(24f),0,0)
    }

    /**
     * 填充数据
     */
    fun initData(bean: HomeHeaderBean?) {
        initBanner(bean?.focusList)
        pageContainer?.initData(bean)
        //设置实时预约数据
        realTestView!!.initData(bean?.homeSaleData)
    }

    /**
     * 初始化实时测评状态View
     */
    private fun initRealTextView() {
        if (null == realTestView) {
            var realTestParam = FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
            realTestView = HomePagerBannerRealView(context, homeEvent!!)
            realTestView!!.layoutParams = realTestParam
            homeModulePagerBannerViewAddLayout.addView(realTestView)
        }
    }

    /**
     * 更新banner
     */
    private fun initBanner(focusListBean: List<HomeHeaderBean.FocusListBean>?) {
        //临时缓存集合
        val cacheList = ArrayList<HomeHeaderBean.FocusListBean>()
        if (null != focusListBean && focusListBean.isNotEmpty()) {
            mImageViews.clear()
            //产品说取前8个
            if (focusListBean.size > 8){
                cacheList.addAll(focusListBean.subList(0,8))
            }else{
                cacheList.addAll(focusListBean)
            }
            for (item in cacheList) {
                mImageViews.add(item.imageUrl!!)
            }
        }
        homeModulePagerBannerViewBanner.setImageLoader(GlideImageLoader(R.drawable.home_image_default_back)).setImages(mImageViews).start()

        homeModulePagerBannerViewBanner.setOnBannerListener {
            if (it < cacheList?.size) {
                homeEvent?.bannerClick(cacheList[it])
                YdlBuryPointUtil.sendClick("ydl-user-home-banner$it","${cacheList[it].imageUrl}")
            }
        }
    }

    fun startBanner() {
        if (homeModulePagerBannerViewBanner != null) {
            homeModulePagerBannerViewBanner.startAutoPlay()
        }
    }

    fun stopBanner() {
        if (homeModulePagerBannerViewBanner != null) {
            homeModulePagerBannerViewBanner.stopAutoPlay()
        }
    }
}