package com.yidianling.im.config.provider

import com.netease.nimlib.sdk.RequestCallbackWrapper
import com.netease.nimlib.sdk.ResponseCode
import com.netease.nimlib.sdk.uinfo.model.NimUserInfo
import com.yidianling.nimbase.api.model.SimpleCallback
import com.yidianling.nimbase.api.model.user.IUserInfoProvider
import com.yidianling.nimbase.impl.cache.NimUserInfoCache
import java.util.*

/**
 * Created by haorui on 2019/5/20.
 * Des:
 */
class UIKitUserInfoProvider : IUserInfoProvider<NimUserInfo> {
    override fun getUserInfo(account: String): NimUserInfo? {
        val user = NimUserInfoCache.getInstance().getUserInfo(account)
        if (user == null) {
            NimUserInfoCache.getInstance().getUserInfoFromRemote(account, null)
        }

        return user
    }

    override fun getUserInfo(accounts: List<String>): List<NimUserInfo> {
        val users = ArrayList<NimUserInfo>()
        for (account in accounts) {
            val userInfo = getUserInfo(account)
            if (userInfo != null) {
                users.add(userInfo)
            }
        }
        return users
    }

    override fun getUserInfoAsync(account: String, callback: SimpleCallback<NimUserInfo>?) {
        NimUserInfoCache.getInstance().getUserInfoFromRemote(account, object : RequestCallbackWrapper<NimUserInfo>() {
            override fun onResult(code: Int, result: NimUserInfo, exception: Throwable) {
                callback?.onResult(code == ResponseCode.RES_SUCCESS.toInt(), result, code)
            }
        })
    }

    override fun getUserInfoAsync(accounts: List<String>, callback: SimpleCallback<List<NimUserInfo>>?) {
        NimUserInfoCache.getInstance().getUserInfoFromRemote(accounts, object : RequestCallbackWrapper<List<NimUserInfo>>() {
            override fun onResult(code: Int, result: List<NimUserInfo>, exception: Throwable) {
                callback?.onResult(code == ResponseCode.RES_SUCCESS.toInt(), result, code)
            }
        })
    }
}
