package com.yidianling.im.dialog

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.WindowManager
import com.yidianling.im.R
import kotlinx.android.synthetic.main.im_customer_card_send_remind_dialog.*

/**
 * Created by xj on 2019/10/29.
 */
class CustomerCardSendRemindDialog(val mContext: Context, val listener: CustomerCardSendDialogListener): Dialog(mContext, R.style.dialog_default_style) {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.im_customer_card_send_remind_dialog)

        val params = window.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = WindowManager.LayoutParams.MATCH_PARENT
        window.attributes = params

        customer_card_send_dialog_cancel.setOnClickListener { dismiss() }

        customer_card_send_dialog_sure.setOnClickListener {
            listener?.sureClick()
            dismiss()
        }


    }

    interface CustomerCardSendDialogListener{
        fun sureClick()
    }

}