package com.yidianling.im.router

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.util.Log
import com.alibaba.android.arouter.launcher.ARouter
import com.netease.nimlib.sdk.NIMClient
import com.netease.nimlib.sdk.RequestCallback
import com.netease.nimlib.sdk.auth.LoginInfo
import com.netease.nimlib.sdk.msg.MsgService
import com.netease.nimlib.sdk.msg.model.IMMessage
import com.netease.nimlib.sdk.uinfo.UserService
import com.netease.nimlib.sdk.uinfo.constant.UserInfoFieldEnum
import com.ydl.confide.api.IConfideService
import com.ydl.course.api.ICourseService
import com.ydl.ydl_router.manager.YDLRouterManager
import com.ydl.ydlcommon.base.config.HttpConfig
import com.ydl.ydlcommon.bean.GlobalInfo
import com.ydl.ydlcommon.data.PlatformDataManager
import com.ydl.ydlcommon.data.http.GsonProvider
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.ydl.ydlcommon.router.IYDLRouterConstant
import com.yidianling.consultant.api.IConsultantService
import com.yidianling.dynamic.api.IDynamicService
import com.yidianling.fm.api.service.IFMService
import com.yidianling.im.api.bean.ReceiveRedPacketParam
import com.yidianling.im.api.service.IImService
import com.yidianling.im.config.constants.UserPreferences
import com.yidianling.im.preference.IMCache
import com.yidianling.tests.api.service.ITestsApiService
import com.yidianling.uikit.api.NimUIKit
import com.yidianling.user.api.bean.UserResponseBean
import com.yidianling.user.api.service.IAppService
import com.yidianling.user.api.service.IUserService

/**
 * 功能输入接口
 * 暴漏给app模块使用
 * Created by hgw on 2018/3/19.
 */
object ImIn {

    fun getImService(): IImService {
        return ModularServiceManager.provide(IImService::class.java)
    }

    fun getAppService(): IAppService {
        return ModularServiceManager.provide(IAppService::class.java)
    }

    fun getUserService(): IUserService {
        return ModularServiceManager.provide(IUserService::class.java)
    }

    fun getDynamicService(): IDynamicService {
        return ModularServiceManager.provide(IDynamicService::class.java)
    }

    fun getCourseService(): ICourseService{
        return ModularServiceManager.provide(ICourseService::class.java)
    }

    fun getTestsService(): ITestsApiService{
        return ModularServiceManager.provide(ITestsApiService::class.java)
    }

    fun getFMService(): IFMService{
        return ModularServiceManager.provide(IFMService::class.java)
    }

    fun getConsultService(): IConsultantService {
        return ModularServiceManager.provide(IConsultantService::class.java)
    }

    fun getConfideService(): IConfideService {
        return ModularServiceManager.provide(IConfideService::class.java)
    }

    /**
     * 获取专家主页url
     */
    fun getExpertHost(): String {
        return  HttpConfig.MH5_URL + "jy/experts/"
    }

    fun getShareExpertHost(): String {
        return  HttpConfig.MH5_URL+ "experts/"
    }

    fun getReserveHost(): String {
        return  HttpConfig.H5_URL+"booking/order-detail?orderid="
    }

    /**
     * 更新用户设置
     */
    fun setChatTeamHisShowed(){
        getUserService()?.setChatTeamHisShowed(true)
    }

    /**
     * 是否登录
     */
    fun isLogin(activity: Context,flag : Boolean):Boolean{
        if (!isLogin() && flag) {
            getUserService().loginByOneKeyLogin(activity,true)
            return false
        }else{
            return true
        }
    }

    fun membersIntent(activity: Activity, userId: String): Intent? {
        return getDynamicService().membersIntent(activity, userId)
    }

    fun replayInfoIntent(activity: Activity, replyId: String, aid: String): Intent? {
        return getDynamicService().replyInfoIntent(activity, replyId, aid)
    }

    fun myRedPockIntent(activity: Activity){
        getAppService().myRedPockIntent(activity)
    }

    fun trendsDetailIntent(activity: Activity, trendId: Int): Intent? {
        return getDynamicService().trendsDetailIntent(activity, trendId)
    }

    fun trendsDetailIntent(activity: Activity, trendId: Int, isScrollToZan: Boolean): Intent? {
        return getDynamicService().trendsDetailIntent(activity, trendId, isScrollToZan)
    }

    fun trendsDetailIntent(activity: Activity, trendId: Int, isScrollToZan: Boolean, lastId: Int): Intent? {
        return getDynamicService().trendsDetailIntent(activity, trendId, isScrollToZan, lastId)
    }

    /**
     * 跳转话题详情
     */
    fun topicDetailActivity(context: Activity,topic_id : String){
        var intent = getDynamicService().topicDetailIntent(context, false,topic_id)
        intent?.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
        context.startActivity(intent)
    }

    /**
     * 课程专题页面
     */
    fun courseTopic(activity: Activity,id : String){
        getCourseService().courseTopic(activity,id)
    }

    fun fmDetailIntent(activity: Activity, id: Int): Intent? {
        return getFMService().fmDetailIntent(activity, id)
    }

    fun sendRedPacketIntent(activity: Activity, toUid: String,code:Int){
        ARouter.getInstance().build("/user/sendRedPacket").withString("to_uid",toUid).navigation(activity,code)
    }

    fun testResultH5(testResultId: Int){
        getTestsService().testH5Result(testResultId.toString())
    }

    fun testDetailH5(testId: Int){
        getTestsService().testDetailH5(testId.toString());
    }

    fun receiveRedPacketIntent(activity: Activity, param: ReceiveRedPacketParam){
        getAppService().receiverRedPacketIntent(activity, GsonProvider.getGson().toJson(param))
    }


    fun inputPhoneIntent(activity: Activity, smsAction: String): Intent? {
        return getUserService().inputPhoneIntent(activity, smsAction)
    }

    /**
     * 获取私聊未读数
     */
    fun getInUnreadNum():Int{
        return NIMClient.getService(MsgService::class.java).getTotalUnreadCount()
    }

    /**
     * 登录im
     */
    fun loginIm(uid : String,pwd : String){
        var info = LoginInfo(uid, pwd);
        var callback :  RequestCallback<LoginInfo>  = object : RequestCallback<LoginInfo> {
            override fun onSuccess(param: LoginInfo?) {
                Log.d("", "")
            }

            override fun onFailed(code: Int) {
            }

            override fun onException(exception: Throwable?) {
            }
        }
        IMCache.setAccount(uid)
        //此代码进行登录,并且会进行回调
        NimUIKit.login(info, callback);
    }

    fun loginIm(uid : String,pwd : String,callback: RequestCallback<LoginInfo>){
        var info = LoginInfo(uid, pwd);
        IMCache.setAccount(uid)
        //此代码进行登录,并且会进行回调
        NimUIKit.login(info, callback);
    }

    /**
     * 更新听筒模式
     */
    fun updateEarMode(boo : Boolean){
        NimUIKit.setEarPhoneModeEnable(boo)
    }

    /**
     * 获取当前听筒模式是否开启
     */
    fun getEarModeIsOpen() : Boolean{
        return NimUIKit.isEarPhoneModeEnable()
    }

    /**
     * 更新用户头像
     */
    fun updateUserHead(head : String){
        var fields = HashMap<UserInfoFieldEnum,Any>(1)
        fields.put(UserInfoFieldEnum.AVATAR, head)
        NIMClient.getService(UserService::class.java).updateUserInfo(fields)
    }

    /**
     * 更新用户昵称
     */
    fun updateUserName(name : String){
        var fields = HashMap<UserInfoFieldEnum,Any>(1)
        fields.put(UserInfoFieldEnum.Name, name)
        NIMClient.getService(UserService::class.java).updateUserInfo(fields)
    }

    /**
     * 设置通知声音开关
     */
    fun setRing(boo: Boolean){
        val config = UserPreferences.getStatusConfig()
        config.ring = boo
        UserPreferences.setStatusConfig(config)
        NIMClient.updateStatusBarNotificationConfig(config)
    }

    /**
     * 设置震动开关
     */
    fun setVibrate(boo: Boolean){
        val config = UserPreferences.getStatusConfig()
        config.vibrate = boo
        UserPreferences.setStatusConfig(config)
        NIMClient.updateStatusBarNotificationConfig(config)
    }

    fun isLogin(): Boolean {
        return getUserService()?.isLogin()?:false
    }

    fun getUserInfo(): UserResponseBean.UserInfo? {
        return getUserService().getUserInfo()
    }

    fun getUserResponse():UserResponseBean?{
        return getUserService().getUserResponse()
    }

    fun getChatTeamHisShow(): Boolean {
        return getUserService().getChatTeamHisShow()?:false
    }

    fun loginWayIntent(context: Context): Intent? {
        return getUserService().loginWayIntent(context)
    }

    fun mainIntent(context: Context, selectTab: Int){
        getAppService().mainIntent(context, selectTab, false)
    }

    fun feedBackIntent(activity: Activity){
        getAppService().feedBackIntent(activity)
    }

    fun getGlobalInfo(): GlobalInfo? {
        return PlatformDataManager.getRam().getGlobalInfo()
    }
    /**
     * 调用优先使用一键登录，并返回调用时的登录状态，
     * @param isOpenDialog true:一键登录使用弹窗展示 false:一键登录使用全屏模式
     * @return true：已登录，不触发登录跳转，false：未登录，优先一键登录
     * */
    fun loginByOneKeyLogin(context: Context, isOpenDialog: Boolean) :Boolean{
        return getUserService().loginByOneKeyLogin(context,isOpenDialog)
    }
    lateinit var  imMessage:IMMessage

    fun setLocalExten(imMessage:IMMessage){
        this.imMessage=imMessage
    }
    fun getImmessage():IMMessage {
        return imMessage
    }
}
