package com.yidianling.im.session.action;

import com.yidianling.avchatkit.activity.AVChatActivity;
import com.yidianling.uikit.custom.bridge.ActionHandlerStorage;
import com.netease.nimlib.sdk.avchat.constant.AVChatType;
import com.yidianling.common.tools.ToastUtil;
import com.yidianling.im.R;
import com.yidianling.im.router.ImIn;
import com.yidianling.nimbase.business.session.actions.BaseAction;
import com.yidianling.nimbase.impl.cache.NimUserInfoCache;

import org.json.JSONObject;

/**
 * 用户私聊视频按钮h5介绍
 * Created by z on 2017/2/23.
 */

public class H5VideoAction extends BaseAction {

    private AVChatType avChatType;

    /**
     * 构造函数
     * <p>
     * iconResId 图标 res id
     * titleId   图标标题的string res id
     */
    public H5VideoAction(AVChatType avChatType) {
        super(R.drawable.im_chatbar_audiocall, R.string.im_input_panel_video_h5);
        this.avChatType = avChatType;
    }

    @Override
    public void onClick() {
        //跳转h5的视频介绍
        if (ActionHandlerStorage.getL(getAccount()) != null) {
            try {
                JSONObject jsb = new JSONObject();
                jsb.put("button_name", "语音/视频");
                ActionHandlerStorage.getL(getAccount()).buryPoint("messageClick", jsb);
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (ImIn.INSTANCE.getUserInfo().getUser_type() == 3) {
                //助理可以对专家和用户发起语音视频
                AVChatActivity.outgoingCall(getActivity(), getAccount(), NimUserInfoCache.getInstance().getUserInfo(getAccount()).getName(),avChatType.getValue(), AVChatActivity.FROM_INTERNAL);
            } else {
                ActionHandlerStorage.getL(getAccount()).h5Video();
            }
        } else {
            ToastUtil.toastShort("请退出聊天重试");
        }

    }
}
