package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

/**
 * 完善咨询资料提醒消息
 * Created by harvie on 2017/1/10.
 */

public class CustomAttachConsultPerfectData extends CustomAttachment {

    private final String URL = "url";
    private final String TITLE = "title";
    private final String TIPS = "tips";
    private final String FLAG = "flag";

    public String url;//跳转url
    public String title;
    public String tips;//提醒消息
    public int flag;//0提醒完善文字消息 1 带背景提示完善消息 2 已完善消息

    public CustomAttachConsultPerfectData() {
        super(CustomAttachmentType.TYPE_CONSULT_PERFECT_DATA);
    }

    public CustomAttachConsultPerfectData(String url, String title, String tips, int flag) {
        super(CustomAttachmentType.TYPE_CONSULT_PERFECT_DATA);
        this.url = url;
        this.title = title;
        this.tips = tips;
        this.flag = flag;

    }

    @Override
    protected void parseData(JSONObject data) {
        url = data.getString(URL);
        title = data.getString(TITLE);
        tips = data.getString(TIPS);
        flag = data.getInteger(FLAG);

    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(URL,url);
        data.put(TITLE,title);
        data.put(TIPS,tips);
        data.put(FLAG,flag);


        return data;
    }
}
