package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;


/**
 * 确认预约时间
 * Created by harvie on 2017/1/10.
 */

public class CustomAttachConsultSubScript extends CustomAttachment {

    private String TITLE = "title";
    private String PRODUCT_NAME = "productName";
    private String CONSULT_DATE = "bookingTime";
    private String CONSULT_TIME = "consultDuration";
    private String CONSULT_TYPE = "serviceType";
    private String FLAG = "flag";
    private String URL = "url";
    private String IS_PACKAGE = "isPackage";
    private static final String NEWSORDERID = "newOrderId";//用于跳转新版订单详情
    private static final String STATUS = "status";//状态，1代表已确认，0代表待确认


    public String title; //自定义消息标题
    public String productName;//商品名称
    public String consultDate;//咨询时间
    public String consultTime;//咨询时长
    public String consultType;//咨询方式
    public String url;//跳转url
    public int flag;//0 未确认 1已确认
    public byte isPackage = 0; //是否套餐 1单次 2套餐
    /***新订单*/
    public String newOrderId;
    public int status;

    public CustomAttachConsultSubScript() {
        super(CustomAttachmentType.TYPE_CONSULT_SUBSCRIBE_SURE);
    }

    @Override
    protected void parseData(JSONObject data) {
        title = data.getString(TITLE);
        productName = data.getString(PRODUCT_NAME);
        consultDate = data.getString(CONSULT_DATE);
        consultTime = data.getString(CONSULT_TIME);
        consultType = data.getString(CONSULT_TYPE);
        url = data.getString(URL);
        flag = data.getInteger(FLAG);
        isPackage = data.getByte(IS_PACKAGE);
        this.newOrderId = data.getString(NEWSORDERID);
        this.status = data.getInteger(STATUS);

    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(TITLE,title);
        data.put(PRODUCT_NAME,productName);
        data.put(CONSULT_DATE,consultDate);
        data.put(CONSULT_TIME,consultTime);
        data.put(CONSULT_TYPE,consultType);
        data.put(URL,url);
        data.put(FLAG,flag);
        data.put(IS_PACKAGE,isPackage);
        data.put(NEWSORDERID, newOrderId);
        data.put(STATUS, status);
        return data;
    }
}
