package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

/**
 * Created by wi1ls on 2017/1/13.
 */

public class CustomAttachmentRedStatus extends CustomAttachment {
    private static final String KEY_FROM_CONTENT = "from_content";
    private static final String KEY_FROM_UID = "from_uid";
    private static final String KEY_TO_CONTENT = "to_content";
    private static final String KEY_TO_UID = "to_uid";
    private static final String KEY_POCKET_ID="pocket_id";

    private String from_content;
    private String from_uid;
    private String to_content;
    private String to_uid;
    private String pocket_id;

    public CustomAttachmentRedStatus() {
        super(CustomAttachmentType.REDSTATUS);
    }

    @Override
    protected void parseData(JSONObject data) {
        from_content = data.getString(KEY_FROM_CONTENT);
        from_uid = data.getString(KEY_FROM_UID);
        to_content = data.getString(KEY_TO_CONTENT);
        to_uid = data.getString(KEY_TO_UID);
        pocket_id=data.getString(KEY_POCKET_ID);
    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(KEY_FROM_CONTENT, from_content);
        data.put(KEY_FROM_UID, from_uid);
        data.put(KEY_TO_CONTENT, to_content);
        data.put(KEY_TO_UID, to_uid);
        data.put(KEY_POCKET_ID,pocket_id);
        return data;
    }

    public String getFrom_content() {
        return from_content;
    }

    public String getFrom_uid() {
        return from_uid;
    }

    public String getTo_content() {
        return to_content;
    }

    public String getTo_uid() {
        return to_uid;
    }

    public String getPocket_id() {
        return pocket_id;
    }
}
