package com.yidianling.im.session.viewholder;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachAssistantReceivedMoney;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;


/**
 * 收款消息拓展
 * Created by wi1ls on 2017/1/10.
 */

public class MsgViewHolderAssistantReceivedMoney extends MsgViewHolderBase {

    private String num;//订单金额
    private String title;//订单标题题
    private int orPay;//支付状态 0未支付1已支付
    private String url;//订单url

    private View message_received;
    private TextView tit,content;
    private ImageView img;

    public MsgViewHolderAssistantReceivedMoney(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }


    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_received_money;
    }

    @Override
    protected void inflateContentView() {
        message_received=findViewById(R.id.message_received);
        tit = findViewById(R.id.packet_title);
        content = findViewById(R.id.text_content);
        img = findViewById(R.id.packte_im);
    }

    @Override
    protected void bindContentView() {
        CustomAttachAssistantReceivedMoney customAttachReceivedMoney= (CustomAttachAssistantReceivedMoney) message.getAttachment();
        url=customAttachReceivedMoney.getUrl();
        num = customAttachReceivedMoney.getNum();
        title = customAttachReceivedMoney.getTitle();
        orPay = customAttachReceivedMoney.getOrPay();
        num = customAttachReceivedMoney.getNum();

        if (title!=null)tit.setText(title);
        if (orPay == 1) {
            //支付成功
            if (num!=null)content.setText("您支付了"+num+"元");
            img.setImageDrawable(view.getResources().getDrawable(R.mipmap.im_zhifu));
        }else{
            if (num!=null)content.setText("您需要支付"+num+"元");
            img.setImageDrawable(view.getResources().getDrawable(R.mipmap.im_weifu));
        }

        hideItemBg();
    }

    @Override
    protected void onItemClick() {
        if (isReceivedMessage()) {
            NewH5Activity.start(view.getContext(), new H5Params(url, null));
        }
    }

}
