package com.yidianling.im.session.viewholder;

import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachConsultCallStatus;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;

/**
 * Created by zhoujianghua on 2015/8/6.
 */
public class MsgViewHolderConsultCallStatus extends MsgViewHolderBase {

    private ImageView typeImage;
    private TextView statusLabel;

    public MsgViewHolderConsultCallStatus(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_custom_consult_call_status;
    }

    @Override
    protected void inflateContentView() {
        typeImage = findViewById(R.id.type_img);
        statusLabel = findViewById(R.id.tv_state);
    }

    @Override
    protected void bindContentView() {
        CustomAttachConsultCallStatus customAttachTipMsg = (CustomAttachConsultCallStatus) message.getAttachment();
        layoutByDirection(customAttachTipMsg);

    }

    private void layoutByDirection(CustomAttachConsultCallStatus customAttachTipMsg) {

        if (isReceivedMessage()) {
            typeImage.setImageResource(R.drawable.im_avchat_left_type_audio);
        } else {
            typeImage.setImageResource(R.drawable.im_avchat_right_type_audio);
        }

        if (TextUtils.equals("1", customAttachTipMsg.getStatus())) {
            typeImage.setVisibility(View.VISIBLE);
            if ("true".equals(customAttachTipMsg.getIsConsultOrder())) {
                statusLabel.setText("通话接听时长 " + customAttachTipMsg.getDuration());
            } else {
                statusLabel.setText("通话拨打时长 " + customAttachTipMsg.getDuration());
            }
        } else {
            typeImage.setVisibility(View.GONE);
            if (isReceivedMessage()) {
                statusLabel.setText(customAttachTipMsg.getCallee());
            } else {
                statusLabel.setText(customAttachTipMsg.getCaller());
            }
        }
        //只有倾诉加角标，咨询不加
        if (!"true".equals(customAttachTipMsg.getIsConsultOrder())) {
            showAudioSmallTip();
        } else {
            hideAudioSmallTip();
        }
    }

    @Override
    protected int leftBackground() {
        CustomAttachConsultCallStatus customAttachTipMsg = (CustomAttachConsultCallStatus) message.getAttachment();
        if (!"true".equals(customAttachTipMsg.getIsConsultOrder())) {
            return R.drawable.im_message_receive_content_tip_bg;
        } else {
            return R.drawable.im_message_receive_content_bg;
        }
    }

    @Override
    protected int rightBackground() {
        CustomAttachConsultCallStatus customAttachTipMsg = (CustomAttachConsultCallStatus) message.getAttachment();
        if (!"true".equals(customAttachTipMsg.getIsConsultOrder())) {
            return R.drawable.im_message_send_content_tip_bg;
        } else {
            return R.drawable.im_message_send_content_bg;
        }
    }

}
