package com.yidianling.im.session.viewholder;

import android.text.TextUtils;
import android.widget.TextView;

import com.yidianling.uikit.business.session.helper.MessageListPanelHelper;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;
import com.yidianling.uikit.custom.bridge.ActionHandlerStorage;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.netease.nimlib.sdk.NIMClient;
import com.netease.nimlib.sdk.RequestCallback;
import com.netease.nimlib.sdk.msg.MessageBuilder;
import com.netease.nimlib.sdk.msg.MsgService;
import com.netease.nimlib.sdk.msg.attachment.MsgAttachment;
import com.netease.nimlib.sdk.msg.constant.SessionTypeEnum;
import com.netease.nimlib.sdk.msg.model.IMMessage;
import com.yidianling.common.tools.ToastUtil;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachmentPhoneCallSystemNotice;
import com.ydl.ydlcommon.router.YdlCommonRouterManager;
import com.ydl.ydlcommon.utils.StringUtils;
import com.ydl.ydlcommon.utils.YDLCacheUtils;

/**
 * @author jiucheng
 * @描述: 倾述流程中，根据老师状态（在线、不在线、开通倾述、未开通倾述）发送的自定义消息
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/12/25
 */
public class MsgViewHolderPhoneCallSystemNotice extends MsgViewHolderBase {

    private TextView tpisTv;
    private TextView clickTv;
    private String msgType;//根据此字段显示不同文字  1：邀请开通  2：留言

    public MsgViewHolderPhoneCallSystemNotice(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_phone_call_system_notice;
    }

    @Override
    protected void inflateContentView() {
        tpisTv = view.findViewById(R.id.tv_msg_receive);
        clickTv = view.findViewById(R.id.tv_click_msg);
    }

    @Override
    protected void bindContentView() {
        MsgAttachment attachment = message.getAttachment();
        if (attachment instanceof CustomAttachmentPhoneCallSystemNotice) {
            msgType = ((CustomAttachmentPhoneCallSystemNotice) attachment).getMsgType();
            if (TextUtils.equals("1", msgType)) {
                tpisTv.setText("老师目前没有开通倾诉服务");
                clickTv.setText("邀请开通");
            } else {
                tpisTv.setText("老师现在不便聆听");
                clickTv.setText("给老师留言");
            }
        }
        hideHead();
        hideItemBg();
    }

    @Override
    protected void onItemClick() {
        String localTime;

        //判断今天是否有给老师留过言
        if (TextUtils.equals("1", msgType)) {//邀请开通
            localTime = YDLCacheUtils.Companion.getInviteTime(YdlCommonRouterManager.INSTANCE.getYdlCommonRoute().getUid() + "", ActionHandlerStorage.getL(message.getSessionId()).getInfo().toUid);
        } else {
            localTime = YDLCacheUtils.Companion.getSendMsgTime(YdlCommonRouterManager.INSTANCE.getYdlCommonRoute().getUid() + "", ActionHandlerStorage.getL(message.getSessionId()).getInfo().toUid);
        }


        //是否是同一天
        if (StringUtils.compareTime(localTime)) {//是同一天
            if (TextUtils.equals("1", msgType)) {//邀请开通
                ToastUtil.toastShort("已邀请");
            } else {// 留言
                ToastUtil.toastShort("已留言");
            }
            return;
        }

        String text;
        String toast;
        if (TextUtils.equals("1", msgType)) {//发送邀请开通   老师好，我想邀请您开通倾诉务，您可以联系客服申请开通
            text = "老师好，我想邀请您开通倾诉服务，您可以联系客服申请开通";
            toast = "已邀请";
        } else {// 发送留言   老师好，我想找您倾诉，请尽快上线私聊我，我在等您
            text = "老师好，我想找您倾诉，请尽快上线私聊我，我在等您";
            toast = "已留言";
        }

        IMMessage textMessage = MessageBuilder.createTextMessage(ActionHandlerStorage.getL(message.getSessionId()).getInfo().toUid, SessionTypeEnum.P2P, text);
        NIMClient.getService(MsgService.class)
                .sendMessage(textMessage, false).setCallback(new RequestCallback<Void>() {
            @Override
            public void onSuccess(Void aVoid) {
                if (TextUtils.equals("1", msgType)) {//邀请开通
                    YDLCacheUtils.Companion.saveInviteTime(YdlCommonRouterManager.INSTANCE.getYdlCommonRoute().getUid() + "", ActionHandlerStorage.getL(message.getSessionId()).getInfo().toUid, System.currentTimeMillis() + "");
                } else {
                    YDLCacheUtils.Companion.saveSendMsgTime(YdlCommonRouterManager.INSTANCE.getYdlCommonRoute().getUid() + "", ActionHandlerStorage.getL(message.getSessionId()).getInfo().toUid, System.currentTimeMillis() + "");
                }
//                ToastUtil.toastShort(toast);
            }

            @Override
            public void onFailed(int i) {
                if (i == 7101) {
                    ToastUtil.toastShort("您已被对方拉黑!");
                } else if (i == 404) {
                } else {
                    //上传至后台
                    ActionHandlerStorage.getL(message.getSessionId()).uploadSendMessageError(i);
                }
            }

            @Override
            public void onException(Throwable throwable) {

            }
        });
        MessageListPanelHelper.getInstance().notifyAddMessage(textMessage);
    }
}
