package com.yidianling.im.session.viewholder;

import android.app.Activity;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import android.widget.TextView;

import com.ydl.ydlcommon.data.http.RxUtils;
import com.ydl.ydlcommon.utils.NetworkParamsUtils;
import com.ydl.ydlcommon.utils.UserInfoCache;
import com.ydl.ydlcommon.utils.remind.HttpErrorUtils;
import com.yidianling.common.tools.LogUtil;
import com.yidianling.im.R;
import com.yidianling.im.bean.RedPacketDetailBean;
import com.yidianling.im.bean.RedPacketDetailCmd;
import com.yidianling.im.http.ImRetrofitApi;
import com.yidianling.im.router.ImIn;
import com.yidianling.im.session.extension.CustomAttachmentRedStatus;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.im.api.bean.ReceiveRedPacketParam;
import com.yidianling.user.api.bean.UserResponseBean;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;


/**
 * Created by wi1ls on 2017/1/13.
 */

public class MsgViewHolderRedStatus extends MsgViewHolderBase {
    private TextView message_receive_tv;
    private String pocket_id;

    public MsgViewHolderRedStatus(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_red_status;
    }

    @Override
    protected void inflateContentView() {
        message_receive_tv = findViewById(R.id.message_receive_tv);
    }

    @Override
    protected void bindContentView() {
        CustomAttachmentRedStatus customAttachmentRedStatus = (CustomAttachmentRedStatus) message.getAttachment();
        String from_content = customAttachmentRedStatus.getFrom_content();
        LogUtil.d("from content: "+from_content);
        pocket_id = customAttachmentRedStatus.getPocket_id();
        int redIndex = from_content.indexOf("红包");
        SpannableStringBuilder ssb = new SpannableStringBuilder(from_content);
        ForegroundColorSpan fcs = new ForegroundColorSpan(0xffd3574c);
        ssb.setSpan(fcs, redIndex, redIndex + 2, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        message_receive_tv.setText(
                ssb
        );
        hideItemBg();
        hideHead();
    }

    @Override
    protected void onItemClick() {
        RedPacketDetailCmd cmd = new RedPacketDetailCmd(pocket_id);
        Disposable subscribe = ImRetrofitApi.Companion.getImRetrofitApi().redPacketDetail(NetworkParamsUtils.getMaps(cmd))
                .compose(RxUtils.INSTANCE.resultData())
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(resp -> {
                    RedPacketDetailBean data = resp;
                    UserInfoCache.YDLUser user = UserInfoCache.getInstance().getUser(data.to_uid);
                    if ((ImIn.INSTANCE.getUserInfo().getUid() + "").equals(data.uid)) {

                        UserResponseBean.UserInfo userInfo = ImIn.INSTANCE.getUserInfo();
                        ReceiveRedPacketParam param = new ReceiveRedPacketParam(
                                data.status,
                                data.money,
                                userInfo.getNick_name(),
                                userInfo.getHead(),
                                user.getAvatar(),
                                user.getNickName(),
                                data.get_time
                        );
                        ImIn.INSTANCE.receiveRedPacketIntent((Activity) context, param);


                    }
                }, throwable -> HttpErrorUtils.Companion.handleError(context, throwable));

    }
}
