package com.yidianling.im.session.viewholder;

import android.widget.ImageView;
import android.widget.TextView;

import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;
import com.yidianling.uikit.custom.bridge.ActionHandlerStorage;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.ydl.ydl_image.module.GlideApp;
import com.yidianling.common.tools.ToastUtil;
import com.yidianling.im.R;
import com.yidianling.im.router.ImIn;
import com.yidianling.im.session.extension.CustomAttachmentTest;

/**
 * 发送测试题
 * Created by Wi1ls on 2016/11/9;
 */
public class MsgViewHolderSendTest extends MsgViewHolderBase {
    private TextView tv_title;
    private ImageView iv_img;
    private TextView tv_flag;
    private TextView check;

    private int flag;
    private String url;
    private String title;
    private String image;
    private String share_url;

    public MsgViewHolderSendTest(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_p2p_send_test;
    }

    @Override
    protected void inflateContentView() {
        tv_title = (TextView) view.findViewById(R.id.test_title);
        iv_img = (ImageView) view.findViewById(R.id.test_iv);
        tv_flag = (TextView) view.findViewById(R.id.tv_flag);
        check = (TextView) view.findViewById(R.id.check);
    }

    @Override
    protected void bindContentView() {
        CustomAttachmentTest customAttachmentTest = (CustomAttachmentTest) message.getAttachment();
        title = customAttachmentTest.getTitle();
        image = customAttachmentTest.getImg();
        url = customAttachmentTest.getUrl();
        flag = customAttachmentTest.getFlag();
        share_url = customAttachmentTest.getShare_url();
        if (flag == CustomAttachmentTest.FLAG_TESTING) {//收到专家发送的测试题,黑色
            tv_flag.setText("测试题");
            check.setTextColor(0xff000000);
            tv_title.setTextColor(0xff000000);
            tv_flag.setTextColor(0xff000000);
        } else if (flag == CustomAttachmentTest.FLAG_RESULT) {//发送测试结果给专家,白色
            tv_flag.setText("测试结果");
            check.setTextColor(0xffffffff);
            tv_title.setTextColor(0xffffffff);
            tv_flag.setTextColor(0xffffffff);
        }
        tv_title.setText(title);
        GlideApp.with(context)
                .load(image)
                .centerCrop()
                .into(iv_img);
    }

    @Override
    protected void onItemClick() {
        if (url.endsWith("?")) {
            url = url.substring(0, url.length() - 1);
        }
        if (flag == CustomAttachmentTest.FLAG_TESTING) {//测试题目打开

            String url111 = url;
            if (url111 == null) {
                url111 = share_url;
            }
            if (url111 == null) {
                ToastUtil.toastShort("参数错误");
                return;
            }
            try {
                String[] strs = url111.split("/");
                String containsId = strs[strs.length - 1];
                try {
                    int id = Integer.parseInt(containsId.replaceAll("[^0-9]*", ""));
//                    ImIn.INSTANCE.TestDetailActivity(context,id);
//                    context.startActivity(ImIn.INSTANCE.testDetailIntent((Activity) context, id));
                    ImIn.INSTANCE.testDetailH5(id);
                    ActionHandlerStorage.needLoadNewMsg = true;
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        } else if (flag == CustomAttachmentTest.FLAG_RESULT) {//测试结果打开

            try {
//                H5Params h5Params = new H5Params(url, null);
//                NewH5Activity.startForResult(((Activity) view.getContext()), h5Params, 44);
                String[] strs = url.split("/");
                String containsId = strs[strs.length - 1];
                try {
                    int id = Integer.parseInt(containsId.replaceAll("[^0-9]*", ""));
//                    ImIn.INSTANCE.TestDetailActivity(context,id);
//                    context.startActivity(ImIn.INSTANCE.testDetailIntent((Activity) context, id));
//                    context.startActivity(ImIn.INSTANCE.testResultIntent((Activity) context, id));
                    ImIn.INSTANCE.testResultH5(id);
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

    }

}
