package com.yidianling.im.session.viewholder;

import android.annotation.SuppressLint;
import android.widget.TextView;

import com.netease.nimlib.sdk.msg.attachment.MsgAttachment;
import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;
import com.ydl.ydlcommon.utils.Utils;
import com.ydl.ydlcommon.utils.remind.HttpErrorUtils;
import com.yidianling.common.tools.ToastUtil;
import com.yidianling.im.R;
import com.yidianling.im.bean.PushConfideStatusBean;
import com.yidianling.im.http.ImRetrofitApi;
import com.yidianling.im.router.ImIn;
import com.yidianling.im.session.extension.CustomAttachmentShareMsg;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.user.api.bean.UserResponseBean;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;

/**
 * Created by haorui on 2019-11-06 .
 * Des: 分享 消息
 * 分享的类型，0：测试；1，课程；2，文章；3：倾诉
 */
public class MsgViewHolderShareMsg extends MsgViewHolderBase {

    private TextView tv_confide_money;
    private TextView tv_confide;
    public String mShareUrl;
    public String mPrice;
    private int mShareType;
    private Disposable mSubscribe;

    public MsgViewHolderShareMsg(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        MsgAttachment attachment = message.getAttachment();
        if (attachment instanceof CustomAttachmentShareMsg) {
            CustomAttachmentShareMsg customMsg = (CustomAttachmentShareMsg) attachment;
            switch (customMsg.getShareType()) {
                //0：测试；
                case 0:
                    return R.layout.im_ui_message_custom_confide;
                //1，课程；
                case 1:
                    return R.layout.im_ui_message_custom_confide;
                //2，文章；
                case 2:
                    return R.layout.im_ui_message_custom_confide;
                //3：倾诉
                case 3:
                    return R.layout.im_ui_message_custom_confide;
            }

        }
        return R.layout.im_ui_message_custom_confide;
    }

    @Override
    protected void inflateContentView() {
        tv_confide_money = view.findViewById(R.id.tv_confide_money);
        tv_confide = view.findViewById(R.id.tv_confide);

    }

    @Override
    protected void bindContentView() {
        MsgAttachment attachment = message.getAttachment();
        if (attachment instanceof CustomAttachmentShareMsg) {
            mShareUrl = ((CustomAttachmentShareMsg) attachment).getShareUrl();
            mPrice = ((CustomAttachmentShareMsg) attachment).getSharePrice();
            mShareType = ((CustomAttachmentShareMsg) attachment).getShareType();
        }

        if (isReceivedMessage()) {
            setAvatarRightInVisibity();
        } else {
            setAvatarLeftInVisibity();
        }

        switch (mShareType) {
            //0：测试；
            case 0:
                break;
            //1，课程；
            case 1:
                break;
            //2，文章；
            case 2:
                break;
            //3：倾诉
            case 3:
                tv_confide_money.setText(mPrice);
                break;
        }
    }

    @Override
    protected void onItemClick() {
        super.onItemClick();
        if (Utils.isFastClick()) {
            //防止连击
            return;
        }
        requestConfideStatus();
    }

    @SuppressLint("CheckResult")
    private void requestConfideStatus() {
        if(mSubscribe != null && !mSubscribe.isDisposed()){
            mSubscribe.dispose();
        }
        UserResponseBean userInfo = ImIn.INSTANCE.getUserResponse();
        mSubscribe = ImRetrofitApi.Companion.getImJavaApi().getPushConfideStatus(userInfo.getUid(), message.getFromAccount()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(it -> {
            if ("200".equals(it.code)) {
                PushConfideStatusBean data = it.data;

                if (data.getIsOpen() != 1) {
                    ToastUtil.toastShort(view.getContext().getString(R.string.im_push_confide_msg_unopened));
                    return;
                }

                if (data.getIsOnline() != 1) {
                    ToastUtil.toastShort(view.getContext().getString(R.string.im_push_confide_msg_offline));
                    return;
                }


                if (data.getIsReducible() != 1) {
                    ToastUtil.toastShort(view.getContext().getString(R.string.im_push_confide_msg_busy));
                    return;
                }

                if (data.getIsStatus() != 1) {
                    ToastUtil.toastShort(view.getContext().getString(R.string.im_push_confide_msg_calling));
                    return;
                }
                NewH5Activity.start(view.getContext(), new H5Params(mShareUrl, null));
            }
        }, t -> {
            HttpErrorUtils.Companion.handleError(context, t);
        });

    }
}
