package com.yidianling.uikit.business.session.fragment;

import android.util.Log;

import com.netease.nimlib.sdk.msg.model.IMMessage;
import com.netease.nimlib.sdk.team.constant.TeamMemberType;
import com.netease.nimlib.sdk.team.model.Team;
import com.netease.nimlib.sdk.team.model.TeamMember;
import com.yidianling.common.tools.ToastUtil;
import com.yidianling.im.R;
import com.yidianling.nimbase.impl.cache.TeamDataCache;
import com.yidianling.uikit.api.NimUIKit;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zhoujianghua on 2015/9/10.
 */
public class YDLTeamMessageFragment extends YDLMessageFragment {

    private Team team;

    @Override
    public boolean isAllowSendMessage(IMMessage message) {
        TeamMember teamMember= TeamDataCache.getInstance().getTeamMember(team.getId(), NimUIKit.getAccount());
        if (team == null || !team.isMyTeam()) {
            ToastUtil.toastShort(getActivity(), R.string.im_team_send_message_not_allow);
            return false;
        }else if (team !=null && team.isAllMute() && teamMember.getType()!= TeamMemberType.Owner && teamMember.getType()!=TeamMemberType.Manager){
            ToastUtil.toastShort("管理员开启了全员禁言哦～");
            return false;
        }
        return true;
    }

    @Override
    public boolean sendMessage(IMMessage message) {
        if (!isAllowSendMessage(message)) {
            return false;
        }
        //如果自己是管理员 发送消息时带上主讲人标志
        Map<String,Object> map = new HashMap<String,Object>();
        TeamMember teamMember= TeamDataCache.getInstance().getTeamMember(sessionId,NimUIKit.getAccount());
        if (teamMember!=null && teamMember.getType()== TeamMemberType.Manager){
            map.put("owner","1");
            message.setRemoteExtension(map);
        }
        return super.sendMessage(message);
    }

    public void setTeam(Team team) {
        Log.e("hzs","-------------setTeam------------TeammessageFragment");
        this.team = team;
    }

}