package com.yidianling.uikit.business.session.view

import android.content.Context
import android.util.AttributeSet
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.LinearLayout
import com.ydl.ydlcommon.utils.LogUtil
import com.yidianling.common.tools.RxImageTool
import com.yidianling.im.R
import kotlin.math.ceil
import kotlin.math.floor

class ImRedStarGradeView : LinearLayout {

    constructor(context: Context) : super(context) {
        mContext = context
        initViews()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        mContext = context
        initViews()
    }

    constructor(context: Context, attrs: AttributeSet, defStyle: Int) : super(
        context,
        attrs,
        defStyle
    ) {
        mContext = context
        initViews()
    }

    private var mContext: Context? = null


    private fun initViews() {
        initView()
    }

    /**
     * 界面初始化
     */
    private fun initView() {
        orientation = HORIZONTAL
        var params = ViewGroup.LayoutParams(
            ViewGroup.LayoutParams.WRAP_CONTENT,
            RxImageTool.dp2px(11f)
        )
        layoutParams = params
    }

    /**
     * 设置分数
     */
    fun setGrade(grade: Float) {
        try {

            val generateGrade = floor(grade.toDouble())
            val generateNumberInt = if (generateGrade.toInt() > 5) 5 else generateGrade.toInt()

            val dp_11 = RxImageTool.dp2px(11f)
            for (i in 0 until generateNumberInt) {
                val itemView = View.inflate(mContext, R.layout.im_good_icon_layout, null)
                val params = LayoutParams(
                    dp_11, dp_11
                )
                itemView.layoutParams = params
                addView(itemView)
            }
            if (grade > generateGrade) {
                val lastRate = grade - generateGrade

                //外部布局
                val itemView = View.inflate(mContext, R.layout.im_good_icon_layout, null)
                val params = LayoutParams(dp_11, dp_11)
                itemView.layoutParams = params

                //左侧红色icon布局
                val redStarIconView = itemView.findViewById<LinearLayout>(R.id.im_red_star)
                val redStarParams =
                    LayoutParams(RxImageTool.dp2px((lastRate * 11f).toFloat()), dp_11)
                redStarIconView.layoutParams = redStarParams

                val redStarIconImg = itemView.findViewById<ImageView>(R.id.im_red_star_icon)
                val redStarIconImgParams = LayoutParams(dp_11, dp_11)
                redStarIconImg.layoutParams = redStarIconImgParams


                // 右侧灰色icon布局
                val greyStarIconView = itemView.findViewById<LinearLayout>(R.id.im_grey_star)
                val greyStarParams = LayoutParams(
                    RxImageTool.dp2px(((1.0f - lastRate) * 11f).toFloat()), dp_11
                )
                greyStarIconView.layoutParams = greyStarParams

                val greyStarIconImg = itemView.findViewById<ImageView>(R.id.im_grey_star_icon)
                val greyStarIconImgParams = LayoutParams(dp_11, dp_11)
                greyStarIconImgParams.gravity = Gravity.RIGHT
                greyStarIconImg.layoutParams = greyStarIconImgParams

                addView(itemView)

            }

            //补全剩余的灰色icon
            val ceilGradeInt = (ceil(grade.toDouble())).toInt()
            for (i in ceilGradeInt until 5) {
                val itemView = View.inflate(mContext, R.layout.im_good_grey_icon_layout, null)
                val params = LayoutParams(
                    dp_11, dp_11
                )
                itemView.layoutParams = params
                addView(itemView)
            }
        } catch (e: Exception) {
            LogUtil.i(e.toString())
        }

    }
}