package com.yidianling.uikit.custom.bridge;

import android.app.Activity;
import android.content.Context;

import com.netease.nimlib.sdk.msg.model.IMMessage;
import com.yidianling.im.api.bean.IMExpertBuild;
import com.yidianling.im.api.bean.ImCommendDetailBean;
import com.yidianling.uikit.custom.http.response.RecommendExpertBean;

import org.json.JSONObject;

import java.util.ArrayList;

/**
 * Created by haorui on 2019/5/16.
 * Des:
 */
public interface IP2PCustomActionHandler {

    DocInfo getInfo();

    Boolean isNotPrepare();

    /***需要筛选的消息*/
    boolean deleteMessage(IMMessage message);

    /***更新专家登录状态*/
    void setDoctorStatus(int status);

    /***设置专家正在咨询的人数*/
    void setDoctorBusyNum(int num);

    /***发送提醒上线的用户消息*/
    void judgeSendRemindMsg(String sessionId);

    /***发送推荐专家列表*/
    void sendRecommendExpertListMessage(String sessionId, ArrayList<RecommendExpertBean> recommendExpertList, int type, boolean showExpertList);

    Activity getmActivity();

    void setmActivity(Activity mActivity);

    void clickMoreIcon();

    void showDingdan(String url);

    /***专家H5主页*/
    void showZhuanjPage();

    /***专家h5主页*/
    void toExpertHome(String doctorId, String name, String cover);

    /***跳转用户主页*/
    void showUserHome();

    void jump();

    /***跳转h5视频介绍*/
    void h5Video();

    //私聊 获取聊天者的订单关系数据(参数cantalk从另一个接口获取)
    //        void getExpert(int toUid,int cantalk);
    void confide();

    void help();

    /***发起收款*/
    void makeColections(String toUid);

    void clear(String accid);

    void put(Activity a);

    void showHelp(String url);

    void resumeUm(Activity activity);

    void pauseUm(Activity activity);

    int getUserType();

    /**
     * 判断是否需要发送自定义消息
     */
    void isNeedSendMsg(boolean isCheckFrom);

    void setUserType(int userType);

    /***获取自己的用户类型*/
    int getSelfUserType();

    /***发红包*/
    void sendRedPacket(Activity activity);

    /***检查用户是否已经绑定手机号*/
    boolean isBindPhone(Activity activity, String toUid);

    /***消息中有11位数字，提示是否要隐藏中间5位*/
    boolean HintMessageSend(Activity activity, ReturnCallBack returnCallBack);

    /*** 举报*/
    void showJubao(Activity activity);

    /***埋点统计*/
    void buryPoint(String eventName, JSONObject properties);

    /***发送自定义提醒消息*/
    void sendCustomMsg();

    /***保存聊天未发送的临时内容*/
    void saveImTempData(String touid, String content);

    /***获取聊天未发送的临时内容*/
    String getImTempData(String touid);

    /***判断是否需要弹出 获取群聊历史记录dialog*/
    void chatTeamHistoryTip(Activity activity);

    /***短时间多次私聊  给予警示*/
    void sendMsgToChatTip();

    /***跳转h5页面 isFresh表示是否需要下拉刷新功能*/
    void h5ActivityStart(Context mActivity, String url, boolean isFresh);

    void uploadSendMessageError(int code);

    void startHelp(Context context);

    void startFeedback(Context context);

    void popCallDialog(Context context);

    void setExpertInfo(String toChatUsername, IMExpertBuild expert);

    class DocInfo {
        public String toUid;
        public String doctorId;
        public String listenerId;
        public String name = "";
        public String title;
        public int is_online; //专家状态 1.在线 2.离线 3通话中 4-继续拨打 ,
        public int isChatOnline; //专家私聊在线状态 1.在线，2.离线，3.忙碌 4咨询中， 5倾述中  6咨询前准备
        public String cover;
        public String desc;
        public String url_share;
        public String price;
        public String unitTxt;
        public String url;
        public int hasAvailableListenOrder; //是否还有未完成的倾诉订单 1、没有 2、有
        public int listenOrderCommentStatus; //倾诉订单评论状态 1：未评价 9：已评价 ,
        public String listenOrderCommentUrl; //倾诉订单评价页url
        public String listenOrderUrl; //订单详情页面url
        public String listenOrderDesc; //倾诉订单状态描述
        public String listenOrderRemainTime; //未完成倾诉订单剩余时间
        public String urlTitle;
        public String blackStatus;
        public String orderid;
        public int listenerIsOpen; //1 开启 2 关闭
        public int is_first = 1; //是否是第一次私聊
        public int busyTotal = 0; //专家当前在与多少人聊天
        public String tag1 = ""; //用与获取推荐专家列表接口的参数catName

        public double doctorBriefInfoFeedbackRate = 0.000;  //好评分
        public String doctorBriefInfoFeedbackRateForShow = "";
        public int doctorBriefInfoOrderNum = 0; //帮助人数
        public int doctorBriefInfoHelpLong = 0; //服务时长
        public String doctorBriefInfoSmallImage = ""; //小头像

        public Boolean isFollowed = false; // 是否关注

        public int commentCounter = 0;
        public String commentCounterUrl = "";
        public ArrayList<ImCommendDetailBean> commentList;
    }

    /**
     * 消息中有11位数字，提示是否要隐藏中间5位  相关
     */
    public interface ReturnCallBack {
        boolean RetCallback();
    }

}
