package com.yidianling.uikit.custom.http

import com.alibaba.fastjson.JSON
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.im.http.ImRetrofitApi
import com.yidianling.uikit.custom.http.response.*
import com.yidianling.uikit.custom.http.response.question.QuestionsInfoBean
import io.reactivex.Observable
import okhttp3.MediaType
import okhttp3.RequestBody

/**
 * Created by xj on 2019/6/26.
 */
class ServiceImpl private constructor() {

    companion object {
        val instance by lazy { ServiceImpl() }
    }

    /**
     * 获取专家登录状态
     */
    fun getDoctorChatStatus(doctorUid: Long): Observable<BaseAPIResponse<ChatStatusBean>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).getDoctorChatStatus(doctorUid)
    }

    /**
     * 获取助理登录状态
     */
    fun getAssistantChatStatus(assistantUid: Long): Observable<BaseAPIResponse<Int>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).getAssistantChatStatus(assistantUid)
    }

    /**
     * 获取推荐专家列表
     */
    fun getRecommendExpertList(
        doctorUid: Long,
        catName: String,
        limit: Int
    ): Observable<BaseAPIResponse<ArrayList<RecommendExpertBean>>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java)
            .getRecommendExpertList(doctorUid, catName, limit)
    }

    /**
     * 获取常用语
     */
    fun getCommonQuestionList(): Observable<BaseAPIResponse<List<CommonQuestionBean>>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).getCommonQuestionList()
    }

    /**
     * 常用语的点击
     */
    fun sendCommonQuestionCount(id: String): Observable<BaseAPIResponse<Any>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).sendCommonQuestionCount(id)
    }

    /**
     * 信息采集的问题
     */
    fun userCollectList(): Observable<BaseAPIResponse<List<UserQuestInfoBean>>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).userCollectList()
    }

    /**
     * 信息采集的问题新版
     */
    fun preExamQuestionPaper(): Observable<BaseAPIResponse<QuestionsInfoBean>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).preExamQuestionPaper()
    }

    /**
     * 获取新用户收集的信息
     */
    fun getNewUserMes(bean: NewUserMesBean): Observable<BaseAPIResponse<List<UserQuestInfoBean>>> {
        val beanStr = JSON.toJSONString(bean)
        val body = RequestBody.create(
            MediaType.parse("application/json; charset=utf-8"),
            beanStr
        ) as RequestBody
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).getNewUserMes(body)
    }

    /**
     * 获取用户来源
     */
    fun getUserSourceFrom(uid: String): Observable<BaseAPIResponse<String>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).getUserSource(uid)
    }

    /**
     * 上传采集的问题
     */
    fun submitUserCollect(params: String): Observable<BaseAPIResponse<Any>> {
        val body = RequestBody.create(
            MediaType.parse("application/json; charset=utf-8"),
            params
        ) as RequestBody
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).submitUserCollect(body)
    }

    /**
     * 关注用户
     */
    fun focus(doctorId: String, status: String): Observable<BaseAPIResponse<Any>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).focus(doctorId, status)
    }

    /**
     * 服务列表
     */
    fun serviceList(doctorId: String): Observable<BaseAPIResponse<List<ServiceItemBean>>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).serviceList(doctorId)
    }

    /**
     * 获取输入框的hint内容
     */
    fun getChatViewConfig(): Observable<BaseAPIResponse<SystemInfoBean>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).getChatViewConfig()
    }


    /**
     * 客户端灵犀信息收集卡题库
     */
    fun getSourceDoctor(
        userUid: String,
        assistantUid: String
    ): Observable<BaseAPIResponse<SourceDoctorInfoBean>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java)
            .getSourceDoctor(1, userUid, assistantUid)
    }

    /**
     * 创建答题信息
     */
    fun createEexams(params: String): Observable<BaseAPIResponse<String>> {
        val body = RequestBody.create(
            MediaType.parse("application/json; charset=utf-8"),
            params
        ) as RequestBody
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).createEexams(body)
    }

    /**
     * 回答问题
     */
    fun answerQuestion(id: String, params: String): Observable<BaseAPIResponse<String>> {
        val body = RequestBody.create(
            MediaType.parse("application/json; charset=utf-8"),
            params
        ) as RequestBody
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).answerQuestion(id, body)
    }

    /**
     * 去聊天 回答问题
     */
    fun lingxiAnswerQuestion(params: String): Observable<BaseAPIResponse<Any>> {
        val body = RequestBody.create(
            MediaType.parse("application/json; charset=utf-8"),
            params
        ) as RequestBody
        return YDLHttpUtils.obtainApi(ImRetrofitApi::class.java).lingxiAnswerQuestion(body)
    }

}