package com.yidianling.uikit.custom.widget

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.Gravity
import android.view.WindowManager
import com.yidianling.im.R
import kotlinx.android.synthetic.main.im_expert_info_dialog_layout.*
import kotlinx.android.synthetic.main.im_safe_help_remind_dialog_layout.*

/**
 * 专家信息弹窗
 * Created by xj on 2019/8/7.
 */
class ExpertInfoDialog(val mContext: Context, val help_num: String, val server_num: String, val good_num: String): Dialog(mContext, R.style.dialog_default_style) {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.im_expert_info_dialog_layout)

        val params = window.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = WindowManager.LayoutParams.WRAP_CONTENT
        window.setGravity(Gravity.CENTER)
        window.attributes = params

        im_expert_detail_help_num.text = help_num
        im_expert_detail_server_num.text = server_num
        im_expert_detail_good_num.text = good_num

        expert_info_close.setOnClickListener {
            if (null != mContext) {
                dismiss()
            }
        }
    }
}