package com.yidianling.uikit.custom.widget.expertConsultService.view

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.widget.LinearLayout
import android.widget.RelativeLayout
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydlcommon.base.config.GlobalConfig
import com.ydl.ydlcommon.base.config.HttpConfig
import com.ydl.ydlcommon.bean.GlobalInfo
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.im.R
import com.yidianling.uikit.custom.http.response.ServiceItemBean
import com.yidianling.uikit.custom.widget.expertConsultService.callback.ConsultServiceViewCallback
import kotlinx.android.synthetic.main.im_expert_consult_service_detail_view.view.*

class ExpertConsultServiceDetailView : RelativeLayout {


    constructor(context: Context, listener: ConsultServiceViewCallback) : super(context) {
        mListener = listener
        mContext = context
        initView()
    }

    private var mListener: ConsultServiceViewCallback? = null
    private var mContext: Context? = null


    private fun initView() {

        val mWidth: Int = RxDeviceTool.getScreenWidth(mContext)
        val mHeight: Int = LayoutParams.MATCH_PARENT

        val params = LayoutParams(
            mWidth,
            mHeight
        )
        params.height = mHeight
        layoutParams = params

        View.inflate(mContext, R.layout.im_expert_consult_service_detail_view, this)

        im_expert_service_list_left_back_btn.setOnClickListener {
            mListener?.onBackClick()
        }
    }

    /**
     * 设置数据
     */
    fun updateData(bean: ServiceItemBean.ProductsBean) {

        val mCompare: Comparator<ServiceItemBean.ProductsBean.ProductSpecDtosBean> = Comparator { o1, o2 ->
            val res = o1.price.compareTo(o2.price)
            when {
                res == 0 -> 0
                res > 0 -> -1
                else -> 1
            }
        }
        if (bean.productSpecDtos != null && bean.productSpecDtos.size > 0) {
            val mBean: ServiceItemBean.ProductsBean.ProductSpecDtosBean = bean.productSpecDtos.sortedWith(mCompare).last()
            //价格，取productSpecDtos数组最后一个价格，不保留小数
            consult_service_service_price.text = String.format(
                "%.0f",
                mBean.price
            )

            if (bean.productDto.isPackage == 2) {
                consult_service_price_right.text = "/${mBean.spec2}分钟" //例： 套餐展示"/60分钟"
            }else {
                consult_service_price_right.text = "/次"//例： 不是套餐展示"/次"
            }
        }

        consult_service_title.text = bean.productDto.name ?: ""
        consult_service_desc.text = bean.productDto.desc ?: ""

        //是否是套餐
        if (bean.productDto.isPackage == 2) {
            consult_service_is_package.text = "套餐"
            consult_service_times.text = "${bean.productDto.packageNum}次"

            //起售次数展示
            consult_service_low_buy_time.visibility = View.VISIBLE
            consult_service_low_buy_time.text = "(${bean.productDto.packageNum}次起售)"
        } else {
            consult_service_is_package.text = "单次"
            consult_service_times.text = "1次"
            consult_service_low_buy_time.visibility = View.GONE
        }

        //可选时间类型
        var timeStr = StringBuffer("")
        var timeList: ArrayList<String> = ArrayList()
        bean.productSpecDtos.forEach {
            timeList.add(it.spec2)
        }
        //去重并按规则拼接
        timeList.distinct().forEachIndexed { index, str ->
            if (index == 0) {
                timeStr.append("${str}分钟")
            } else {
                timeStr.append("/${str}分钟")
            }
        }
        consult_service_once_time_type.text = timeStr.toString()

        //可选服务类型
        var serviceTypeStr = StringBuffer("")
        var serviceTypeList: ArrayList<String> = ArrayList()
        bean.productSpecDtos.forEach {
            serviceTypeList.add(it.spec1)
        }
        //去重并按规则拼接
        serviceTypeList.distinct().forEachIndexed { index, str ->
            val typeStr = getServiceType(str)
            if (typeStr != "未知") {
                if (index == 0) {
                    serviceTypeStr.append("$typeStr")
                } else {
                    serviceTypeStr.append("/$typeStr")
                }
            }
        }
        consult_service_service_type.text = serviceTypeStr.toString()

        consult_service_btn.setOnClickListener {
            NewH5Activity.start(mContext, H5Params(HttpConfig.MH5_URL + "consult/#/pages/DownOrder/DownOrder?product_id=" + bean.productDto.id, null))
        }
    }

    private fun getServiceType(index: String): String {
        return when (index) {
            "1" -> {
                "文字"
            }
            "2" -> {
                "电话"
            }
            "3" -> {
                "当面"
            }
            "4" -> {
                "视频"
            }
            else -> {
                "未知"
            }
        }
    }
}