package com.yidianling.uikit.custom.widget.expertConsultService.view

import android.animation.ObjectAnimator
import android.animation.ValueAnimator
import android.app.Dialog
import android.content.Context
import android.os.Bundle
import androidx.viewpager.widget.PagerAdapter
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import android.view.animation.TranslateAnimation
import android.widget.LinearLayout
import android.widget.ScrollView
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.common.tools.RxImageTool
import com.yidianling.im.R
import com.yidianling.uikit.custom.http.response.ServiceItemBean
import com.yidianling.uikit.custom.widget.expertConsultService.callback.ConsultServiceViewCallback
import kotlinx.android.synthetic.main.im_expert_consult_service_list_dialog_layout.*

/**
 * 专家咨询服务列表弹框
 * Created by xj on 2019/8/7.
 */
class ExpertConsultServiceListDialog(val mContext: Context, val mList: List<ServiceItemBean>): Dialog(mContext, R.style.dialog_default_style) {

    private var mConsultServiceListView: ExpertConsultServiceView? = null
    private var mConsultServiceDetailView: ExpertConsultServiceDetailView? = null
    private var mViewList: ArrayList<View> = ArrayList()
    private var mSelectType: String = "全部"

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.im_expert_consult_service_list_dialog_layout)

        val params = window.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = RxDeviceTool.getScreenHeight(mContext) - RxImageTool.dp2px(100f)
        params.gravity = Gravity.BOTTOM
        window.setWindowAnimations(R.style.bottom_to_top_dialog_style)
        window.attributes = params

        var typeList:ArrayList<String> = ArrayList()
        typeList.add(mSelectType)//默认选中
        mList.forEach { item ->
            typeList.add(item.cateName)
        }

        mConsultServiceListView =
            ExpertConsultServiceView(
                mContext
            )

        (mConsultServiceListView as ExpertConsultServiceView).setDataAndClick(typeList, mList, object : ConsultServiceViewCallback {
            override fun onCloseClick() {
                dismiss()
            }

            override fun onItemClick(serviceBean: ServiceItemBean.ProductsBean) {
                if (mConsultServiceDetailView != null) {
                    mConsultServiceDetailView?.updateData(serviceBean)
                    dialog_bottom_scroll_view.currentItem = 1
                }

            }
        })

        mViewList.add(mConsultServiceListView as View)

        mConsultServiceDetailView =
            ExpertConsultServiceDetailView(
                mContext, object : ConsultServiceViewCallback {
                    override fun onBackClick() {
                        dialog_bottom_scroll_view.currentItem = 0
                    }
                })

        mViewList.add(mConsultServiceDetailView as View)

        dialog_bottom_scroll_view.adapter = ConsultServicePagerAdapter()
        dialog_bottom_scroll_view.currentItem = 0

        setCanceledOnTouchOutside(true)
    }

    internal inner class ConsultServicePagerAdapter : PagerAdapter() {

        override fun getCount(): Int {
            return mViewList.size
        }

        override fun isViewFromObject(view: View, `object`: Any): Boolean {
            return view === `object`
        }

        override fun instantiateItem(container: ViewGroup, position: Int): Any {
            val view = mViewList[position]
            container.addView(view)
            return view
        }

        override fun destroyItem(container: ViewGroup, position: Int, `object`: Any) {
            container.removeView(`object` as View)
        }
    }
}