package com.yidianling.tests.home.event

import android.app.Activity
import android.content.Context
import android.net.Uri
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydl_router.manager.YDLRouterManager
import com.ydl.ydl_router.manager.YDLRouterParams
import com.ydl.ydlcommon.base.config.HttpConfig
import com.ydl.ydlcommon.router.IYDLRouterConstant
import com.ydl.ydlcommon.utils.BuryPointUtils
import com.yidianling.tests.list.view.TestCategoryListActivity
import com.yidianling.tests.router.TestsIn
import com.yidianling.tests.search.TestSearchActivity

/**
 * @author yuanwai
 * @描述:测评首页点击事件实现类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/3
 */
class TestHomeEventImpl(mContext: Context) : ITestHomeEvent {

    var context: Context? = null

    init {
        context = mContext
    }

    /**
     * 跳转我的界面
     */
    override fun jumpMine() {
        if (!TestsIn.loginByOneKeyLogin(context as Activity,true)) {
            return
        }
        val testParam = H5Params(HttpConfig.MH5_URL + "ceshi/my-test", "测试记录")
        NewH5Activity.start(context, testParam)

    }

    /**
     * 跳转搜索界面
     */
    override fun jumpSearch() {
        TestSearchActivity.start(context!!)
    }

    /**
     * banner点击事件
     */
    override fun bannerClick(linkUrl: String?, position: Int, title: String?) {
        //埋点
        BuryPointUtils.getInstance().createMap()
                .put("position", position)
                .put("title", title)
                .burryPoint("ceping_banner")
        link(linkUrl)
    }

    /**
     * 测评分类点击事件
     */
    override fun categoryClick(tabName: String?, position: Int, title: String?, id: String?) {
        //埋点
        BuryPointUtils.getInstance().createMap()
                .put("position", position)
                .put("title", title)
                .burryPoint("ceping_icon")
//        TestListActivity.start(context!!, tabName)
        TestCategoryListActivity.start(context!!, tabName)
    }

    /**
     * 实时测试状态点击事件
     */
    override fun realTestClick(linkUrl: String?, title: String?) {
        //埋点
        BuryPointUtils.getInstance().createMap()
                .put("title", title)
                .burryPoint("ceping_current")
        link(linkUrl)
    }

    /**
     * 每日精选点击事件
     */
    override fun dailyClick(linkUrl: String?, position: Int, title: String?) {
        //埋点
        BuryPointUtils.getInstance().createMap()
                .put("position", position)
                .put("title", title)
                .burryPoint("ceping_Featured")
        link(linkUrl)
    }

    /**
     * 热门推荐点击事件
     */
    override fun recommendedClick(linkUrl: String?, position: Int, title: String?) {
        //埋点
        BuryPointUtils.getInstance().createMap()
                .put("position", position)
                .put("title", title)
                .burryPoint("ceping_recommend")
        link(linkUrl)
    }

    private fun link(linkUrl: String?) {
        if (null == linkUrl || linkUrl.isEmpty()) {
            return
        }
        if (linkUrl.startsWith("app")) {
            val uri = Uri.parse(linkUrl)
            if ("ceshi" == uri.host) {
                val id = uri.getQueryParameter("id")
//                YDLRouterManager.router(IYDLRouterConstant.ROUTER_TEST_DETAIL, YDLRouterParams().putExtra(IYDLRouterConstant.EXTRA_ID, id))
                TestsIn.getTestsImpl().testDetailH5(id)
            }
        } else if (linkUrl.startsWith("http")) {
            YDLRouterManager.router(
                IYDLRouterConstant.ROUTER_H5_H5,
                    YDLRouterParams().putExtra(IYDLRouterConstant.EXTRA_URL, linkUrl), "")
        } else {
            YDLRouterManager.router(linkUrl)
        }
    }

    /**
     * 查看全部测评点击事件
     */
    override fun selectAll() {
//        TestListActivity.start(context!!)
        TestCategoryListActivity.start(context!!)
    }
}