package com.yidianling.tests.list.view.adapter

import android.content.Context
import android.graphics.Color
import android.graphics.Typeface
import androidx.fragment.app.FragmentManager
import androidx.fragment.app.FragmentPagerAdapter
import com.ydl.ydlcommon.view.verticaltablayout.TabAdapter
import com.ydl.ydlcommon.view.verticaltablayout.TabView
import com.yidianling.tests.list.model.bean.TestCategory
import com.yidianling.tests.list.view.TestListFragment

/**
 * 测试列表ViewPager适配器
 * Created by zqk on 17-11-22.
 */
class TestListPagerAdapter(fm: FragmentManager,
                           private val  context: Context,
                           private val testCategoryList: MutableList<TestCategory>
) : FragmentPagerAdapter(fm), TabAdapter {

    private var fragments:HashMap<Int,TestListFragment> = HashMap();

    override fun getIcon(position: Int): TabView.TabIcon? {
        return null
    }

    override fun getTitle(position: Int): TabView.TabTitle {
        return TabView.TabTitle.Builder()
                .setContent(testCategoryList[position].name)
                .setTextColor(Color.parseColor("#333333"), Color.parseColor("#666666"))
                .setBgColor(Color.parseColor("#FFFFFF"), Color.parseColor("#F7F7F7"))
                .setFontFamily(Typeface.defaultFromStyle(Typeface.BOLD), Typeface.defaultFromStyle(Typeface.NORMAL))
                .setTextSize(14)
                .build();
    }

    override fun getBackground(position: Int): Int {
        return 0
    }

    override fun getPageTitle(position: Int): CharSequence = testCategoryList[position].name ?: ""

    override fun getItem(position: Int): TestListFragment {
        var fragment  = TestListFragment.newInstance(testCategoryList[position].tab, testCategoryList[position].id,testCategoryList[position].name);
        fragments[position] = fragment
        return fragment
    }

    fun getFragmentByPosition(position: Int): TestListFragment? {
        return fragments[position]
    }
    override fun getCount(): Int = testCategoryList.size
}