package com.yidianling.user.mine;

import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;
import com.ydl.ydlcommon.base.BaseActivity;
import com.ydl.ydlcommon.bean.StatusBarOptions;
import com.ydl.ydlcommon.bean.VersionData;
import com.ydl.ydlcommon.utils.ApkUpdateDialog;
import com.ydl.ydlcommon.view.JumpTextView;
import com.ydl.ydlcommon.view.TitleBar;
import com.yidianling.common.tools.ToastUtil;
import com.yidianling.user.R;
import com.yidianling.user.mine.data.AppDataManager;
import com.yidianling.user.mine.utils.UpdateUtil;
import com.yidianling.user.ui.login.H5Activity;

import org.jetbrains.annotations.NotNull;


/**
 * 关于我们呢
 * Created by softrice on 15/12/1.
 */
public class AboutUsActivity extends BaseActivity implements  View.OnClickListener {


    //网站介绍;用户协议;版本更新;(鼓励我们)

    TitleBar tb_title;
    ImageView iv_logo;
    //当前版本号
    TextView tv_version;
    JumpTextView jtv_net_protocol;
    JumpTextView jtv_user_protocol;
    JumpTextView jtv_secret_protocol;
    JumpTextView jtv_version_update;
    //升级提醒
    TextView tv_update_point;
    RelativeLayout rl_version_update;
    JumpTextView jtv_encourage_us;

    //升级工具类
    private UpdateUtil updateUtil;

    //是否需要升级
    private boolean isLoad;

    //版本
    private VersionData version;

    @NotNull
    @Override
    public StatusBarOptions getStatusViewOptions() {
        return new StatusBarOptions(true,true);
    }

    @Override
    protected int layoutResId() {
        return R.layout.user_mine_activity_about_us;
    }

    @Override
    protected void initDataAndEvent() {
        tb_title = findViewById(R.id.tb_title);
        iv_logo = findViewById(R.id.iv_logo);
        tv_version = findViewById(R.id.tv_version);
        jtv_net_protocol = findViewById(R.id.jtv_net_protocol);
        jtv_user_protocol = findViewById(R.id.jtv_user_protocol);
        jtv_secret_protocol = findViewById(R.id.jtv_secret_protocol);
        jtv_version_update = findViewById(R.id.jtv_version_update);
        tv_update_point = findViewById(R.id.tv_update_point);
        rl_version_update = findViewById(R.id.rl_version_update);
        jtv_encourage_us = findViewById(R.id.jtv_encourage_us);
        jtv_net_protocol.setOnClickListener(this);
        jtv_user_protocol.setOnClickListener(this);
        jtv_secret_protocol.setOnClickListener(this);
        jtv_version_update.setOnClickListener(this);
        //领导关怀
        findViewById(R.id.jtv_government).setOnClickListener(this);
        //媒体报道
        findViewById(R.id.jtv_media).setOnClickListener(this);
        //联系我们
        findViewById(R.id.jtv_about_us).setOnClickListener(this);
        init();
    }


    void init() {

        updateUtil = UpdateUtil.getInstance();

        tv_version.setText(tv_version.getText().toString() + updateUtil.getAppVersionName(AboutUsActivity.this));
        //判对比服务器版本和当前版本
        checkUp();
    }

    private void checkUp() {

        updateUtil.setUpdateListener(this,
                new UpdateUtil.VersionUpdateListener() {
                    @Override
                    public void setUpdateData(VersionData version1) {
                        //根据获取的version判断是否需要更新
                        version = version1;
                        if (version1 != null) {
                            if (version.ver != null) {
                                jtv_version_update.setRightText(getHeightVersion(version.ver));
                            }
                            boolean isUpdate = updateUtil.needUpdate(getMContext(), version.ver);

                            if (isUpdate) {
                                tv_update_point.setVisibility(View.VISIBLE);

                                isLoad = true;

                            } else {
                                tv_update_point.setVisibility(View.GONE);
                                isLoad = false;
                            }
                        } else {
                            jtv_version_update.setRightText(updateUtil.getAppVersionName(AboutUsActivity.this));
                        }
                    }

                    @Override
                    public void onFailed() {
                        runOnUiThread(() -> jtv_version_update.setRightText(updateUtil.getAppVersionName(AboutUsActivity.this)));
                    }
                });
    }

    /**
     * 返回高版本的版本号（对比本地版本和服务器版本 取最高）
     * @param versionName
     * @return
     */
    private String getHeightVersion(String versionName){
        boolean isLocalVersion = false;
        int localVersion = 0;
        int remoteVersion = 0;
        String currentVersionName = updateUtil.getAppVersionName(AboutUsActivity.this);
        if (!TextUtils.isEmpty(currentVersionName)){
            String localVersionName = currentVersionName.replaceAll("\\.","");
            try {
                localVersion = Integer.valueOf(localVersionName);
            }catch (NumberFormatException e){
                e.printStackTrace();
            }
        }
        if (!TextUtils.isEmpty(versionName)){
            String replaceVersionName = versionName.replaceAll("\\.","");
            try {
                remoteVersion = Integer.valueOf(replaceVersionName);
            }catch (NumberFormatException e){
                e.printStackTrace();
            }
        }
        isLocalVersion = localVersion > remoteVersion;

        return isLocalVersion ? currentVersionName : versionName;
    }

    @Override
    protected void onResume() {
        super.onResume();

        if (AppDataManager.INSTANCE.getLocal().hasUpdate()) {
            jtv_version_update.setLeftRedDotVisibility(View.VISIBLE);
        } else {
            jtv_version_update.setLeftRedDotVisibility(View.GONE);
        }
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();//鼓励我们一下
        if (id == R.id.jtv_net_protocol) {//网站介绍
            H5Params h5Params = new H5Params("https://m.yidianling.com/about", "网站介绍");
            NewH5Activity.start(this, h5Params);
        } else if (id == R.id.jtv_user_protocol) {//用户协议
            H5Activity.start(this, false);
            overridePendingTransition(R.anim.user_slide_in_from_bottom, R.anim.user_slide_null);
        } else if (id == R.id.jtv_secret_protocol) {//隐私政策
            H5Activity.start(this, true);
            overridePendingTransition(R.anim.user_slide_in_from_bottom, R.anim.user_slide_null);
        } else if (id == R.id.jtv_version_update) {//版本更新

            AppDataManager.INSTANCE.getLocal().putUpdate(false);
            if (isLoad) {
                loadLatestVersion();
            } else {
                ToastUtil.toastShort("已经是最新版本咯");
            }
        } else if (id == R.id.jtv_encourage_us) {
        } else if (id == R.id.jtv_government) {//领导关怀
            H5Params governmentH5Params = new H5Params("https://m.yidianling.com/about?type=government", "领导关怀");
            NewH5Activity.start(this, governmentH5Params);
        } else if (id == R.id.jtv_media) {//媒体报道
            H5Params mediaH5Params = new H5Params("https://m.yidianling.com/about?type=media", "媒体报道");
            NewH5Activity.start(this, mediaH5Params);
        } else if (id == R.id.jtv_about_us) {//联系我们
            H5Params aboutUsH5Params = new H5Params("https://m.yidianling.com/about?type=contact", "联系我们");
            NewH5Activity.start(this, aboutUsH5Params);
        }
    }

    //下载最新版本
    private void loadLatestVersion() {
        //弹出版本更新提示
        new ApkUpdateDialog(this).setData(version).show();
    }


}
