package com.yidianling.user.mine

import android.app.Activity
import android.content.Intent
import androidx.fragment.app.Fragment
import androidx.viewpager.widget.ViewPager
import android.view.View
import com.ydl.ydlcommon.adapter.FragmentWithTabPagerAdapter
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.view.widgets.TopTabSelectLayout
import com.yidianling.user.R
import com.yidianling.user.mine.fragment.AddAliAccountFragment
import com.yidianling.user.mine.fragment.AddBankAccountFragment
import kotlinx.android.synthetic.main.user_mine_activity_add_account.*

/**
 * 添加提现帐号
 */
class AddAccountActivity : BaseActivity() {

    companion object {
        fun startForResult(activity: Activity, request: Int) {
            var intent = Intent(activity, AddAccountActivity::class.java)
            activity.startActivityForResult(intent, request)
        }
    }

    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(true, true)
    }

    override fun layoutResId(): Int {
        return R.layout.user_mine_activity_add_account
    }

    override fun initDataAndEvent() {
        var titles = mutableListOf<String>()
        titles.add("支付宝")
        titles.add("银行卡")
        var fragments = mutableListOf<Fragment>()
        fragments.add(AddAliAccountFragment())
        fragments.add(AddBankAccountFragment())
        var adapter = FragmentWithTabPagerAdapter(supportFragmentManager, titles, fragments)
        top_layout.setButtonTitle("支付宝", "银行卡")
        top_layout.setSelectIndex(0)
        top_layout.setLineViewVisible(View.GONE)
        top_layout.setOnSelectTabClickListener(object : TopTabSelectLayout.OnSelectTabClickListener {
            override fun selectTabClickListener(index: Int) {
                viewpager.currentItem = index
            }

            override fun onReturnClickListener() {
            }
        })
        viewpager.currentItem = 0
        viewpager.adapter = adapter
        viewpager.addOnPageChangeListener(object : ViewPager.OnPageChangeListener {
            override fun onPageScrolled(position: Int, positionOffset: Float, positionOffsetPixels: Int) {

            }

            override fun onPageSelected(position: Int) {
                top_layout.setSelectIndex(position)
            }

            override fun onPageScrollStateChanged(state: Int) {

            }
        })
    }
}
