package com.yidianling.user.mine;

import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.View;
import android.widget.TextView;

import com.tbruyelle.rxpermissions2.RxPermissions;
import com.ydl.ydlcommon.base.BaseActivity;
import com.ydl.ydlcommon.bean.StatusBarOptions;
import com.ydl.ydlcommon.data.PlatformDataManager;
import com.ydl.ydlcommon.view.JumpTextView;
import com.ydl.ydlcommon.view.TitleBar;
import com.ydl.ydlcommon.view.dialog.CommonDialog;
import com.yidianling.user.R;

import org.jetbrains.annotations.NotNull;

/**
 * 联系客服
 * Created by softrice on 15/12/1.
 */
public class ContactCustomerServiceActivity extends BaseActivity {

    //    @BindView(R.id.tb_title)
    TitleBar tb_title;
    //    @BindView(R.id.jtv_custom_service)
    JumpTextView jtv_custom_service;
    //    @BindView(R.id.jtv_wechat)
    JumpTextView jtv_wechat;

    //    @BindView(R.id.tv_service_time)
    TextView tvServiceTime;

    String work_time = PlatformDataManager.INSTANCE.getRam().getGlobalInfo() == null ? "早8:30-凌晨2:00" : PlatformDataManager.INSTANCE.getRam().getGlobalInfo().info.work_time;
    final String tel = PlatformDataManager.INSTANCE.getRam().getGlobalInfo() == null ? "400-765-1010" : PlatformDataManager.INSTANCE.getRam().getGlobalInfo().info.tel;
    String wechatAccount = PlatformDataManager.INSTANCE.getRam().getGlobalInfo() == null ? " xinliyidianling" : PlatformDataManager.INSTANCE.getRam().getGlobalInfo().info.wechatAccount;

    private RxPermissions rxPermissions;

    @NotNull
    @Override
    public StatusBarOptions getStatusViewOptions() {
        return new StatusBarOptions(true,true);
    }

    @Override
    protected int layoutResId() {
        return R.layout.user_mine_activity_contact_customer_service;
    }

    @Override
    protected void initDataAndEvent() {
        tb_title = findViewById(R.id.tb_title);
        jtv_custom_service = findViewById(R.id.jtv_custom_service);
        jtv_wechat = findViewById(R.id.jtv_wechat);

        jtv_custom_service.setOnClickListener(v -> {
            String con = "\n400-765-1010\n(服务时间 早8:30-凌晨2:00)";

            if (PlatformDataManager.INSTANCE.getRam().getGlobalInfo() != null && PlatformDataManager.INSTANCE.getRam().getGlobalInfo().info != null) {
                con = PlatformDataManager.INSTANCE.getRam().getGlobalInfo().info.tel + "\n" + PlatformDataManager.INSTANCE.getRam().getGlobalInfo().info.work_time;
            }

            new CommonDialog(this)
                    .setTitle("欢迎致电壹点灵客服热线")
                    .setMessage(con)
                    .setLeftOnclick("取消", new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {

                        }
                    }).setRightClick("拨打", new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent phoneIntent = new Intent(Intent.ACTION_DIAL, Uri.parse("tel:" + tel));
                    startActivity(phoneIntent);
                }
            }).show();
        });

        jtv_wechat.setOnClickListener(v -> {
            copy(wechatAccount, this);
            new CommonDialog(this)
                    .setMessage("壹点灵微信号已复制到粘贴板，请\n打开微信搜索就能关注我们咯～")
                    .setRightClick("好的", new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {

                        }
                    }).show();
        });
        init();
    }


    void init() {
        rxPermissions = new RxPermissions(this);

        jtv_custom_service.setRightText(tel);

    }


    public void copy(String content, Context context) {
        // 得到剪贴板管理器
        ClipboardManager cmb = (ClipboardManager) context.getSystemService(Context.CLIPBOARD_SERVICE);
        cmb.setText(content.trim());
    }

}
