package com.yidianling.user.mine;

import android.content.Intent;
import android.view.View;

import com.ydl.ydlcommon.base.BaseActivity;
import com.ydl.ydlcommon.bean.StatusBarOptions;
import com.ydl.ydlcommon.view.JumpTextView;
import com.yidianling.user.R;
import com.yidianling.user.mine.data.AppDataManager;

import org.jetbrains.annotations.NotNull;

/**
 * 帮助界面
 */
public class HelpActivity extends BaseActivity implements View.OnClickListener {


//    @BindView(R.id.jtv_about_us)
    JumpTextView jtv_about_us;
//    @BindView(R.id.jtv_feed_back)
    JumpTextView jtv_feed_back;
//    @BindView(R.id.jtv_custom_service)
    JumpTextView jtv_custom_service;

    @Override
    protected int layoutResId() {
        return R.layout.user_mine_activity_mine_help;
    }

    @NotNull
    @Override
    public StatusBarOptions getStatusViewOptions() {
        return new StatusBarOptions(true,true);
    }

    @Override
    protected void initDataAndEvent() {
        jtv_about_us = findViewById(R.id.jtv_about_us);
        jtv_feed_back = findViewById(R.id.jtv_feed_back);
        jtv_custom_service = findViewById(R.id.jtv_custom_service);
        jtv_about_us.setOnClickListener(this);
        jtv_feed_back.setOnClickListener(this);
        jtv_custom_service.setOnClickListener(this);
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.jtv_about_us) {//关于我们
            startActivity(new Intent(this, AboutUsActivity.class));
        } else if (id == R.id.jtv_custom_service) {//联系客服
            startActivity(new Intent(this, ContactCustomerServiceActivity.class));
        } else if (id == R.id.jtv_feed_back) {//意见反馈
            startActivity(new Intent(this, FeedBackActivity.class));
        }
    }


    @Override
    protected void onResume() {
        super.onResume();
//        AppSettingBean appSettings = AppSettingSP.Companion.instance().getAppSettings();
        if (AppDataManager.INSTANCE.getLocal().hasUpdate()) {
            jtv_about_us.setLeftRedDotVisibility(View.VISIBLE);
        } else {
            jtv_about_us.setLeftRedDotVisibility(View.GONE);
        }
    }

}
