package com.yidianling.user.mine

import android.app.Activity
import android.content.Intent
import android.os.Build
import android.text.SpannableStringBuilder
import android.text.Spanned
import android.text.TextUtils
import android.text.method.LinkMovementMethod
import android.text.style.ClickableSpan
import android.text.style.ForegroundColorSpan
import android.view.View
import android.widget.LinearLayout
import com.alibaba.android.arouter.facade.annotation.Route
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydl_image.module.GlideApp
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.base.config.HttpConfig
import com.ydl.ydlcommon.data.http.GsonProvider
import com.ydl.ydlcommon.utils.StatusBarUtils
import com.yidianling.common.tools.RxImageTool
import com.yidianling.router.app.ReceiveRedPacketParam
import com.yidianling.user.R
import kotlinx.android.synthetic.main.activity_receive_redpacket.*

/**
 * Created by wi1ls on 2017/1/11.
 * 此界面可以用ViewStub优化
 */
@Route(path = "/user/receiveRedPacket")
class ReceiveRedPacketActivity : BaseActivity(),View.OnClickListener {

/*    internal var status: Int = 0

    internal var money: String? = null

    internal var name: String? = null

    internal var headUrl: String? = null

    internal var expertUrl: String? = null

    internal var expertName: String? = null

    internal var expertTime: String? = null*/

    private lateinit var param: ReceiveRedPacketParam

    companion object {

        private const val PARAM = "param"
        private const val PARAMSTR = "paramStr"

/*        private const val STATUS = "status"
        private const val MONEY = "money"
        private const val NAME = "name"
        private const val HEAD_URL = "head_url"
        private const val EXPERT_URL = "expert_url"
        private const val EXPERT_NAME = "expert_name"
        private const val EXPERT_TIME = "expert_time"*/

        fun newIntent(activity: Activity, param: ReceiveRedPacketParam): Intent {
            val intent = Intent(activity, ReceiveRedPacketActivity::class.java)
            intent.putExtra(PARAM, param)
            return intent
        }
    }

    internal fun init() {
        GlideApp.with(mContext).load(param.headUrl).into(receive_head!!)
        title_bar!!.setDivideBg(-0x2ca8b4)
        when (param.status) {
            2//未领取
            -> {
                if (TextUtils.isEmpty(param.name)){
                    receive_name!!.visibility = View.GONE
                }
                receive_name!!.text = param.name + " 的红包"
                receive_introduce!!.visibility = View.VISIBLE
                receive_unreceived!!.visibility = View.VISIBLE
                receive_unreceived!!.text = "红包金额" + param.money + "元，等待对方领取"
            }
            3//已经领取
            -> {
                if (TextUtils.isEmpty(param.name)){
                    receive_name!!.visibility = View.GONE
                }
                receive_name!!.text = param.name + " 的红包"
                receive_received!!.visibility = View.VISIBLE
                receive_money!!.text = "一个红包金额" + param.money + "元"
                GlideApp.with(mContext).load(param.expertUrl).into(expert_header)
                expert_name!!.text = param.expertName
                expert_time!!.text = param.expertTime
                expert_money!!.text = param.money + "元"
            }
            4//超时
            -> {
                receive_name!!.text = "已超时（过期）"
                receive_name_!!.visibility = View.VISIBLE
                receive_name_!!.text = "金额" + param.money
                val st = "已退回账户余额，查看余额"
                val sub = "查看余额"
                val ssb = SpannableStringBuilder(st)
                val index = st.indexOf(sub)
                val clickableSpan = object : ClickableSpan() {
                    override fun onClick(widget: View) {
                        //进入账户历史金额
                        startActivity(Intent(mContext, AccountHistoryActivity::class.java))
                    }
                }

                val foregroundColorSpan = ForegroundColorSpan(-0x9d8d75)
                ssb.setSpan(clickableSpan, index, index + sub.length, Spanned.SPAN_EXCLUSIVE_INCLUSIVE)
                ssb.setSpan(foregroundColorSpan, index, index + sub.length, Spanned.SPAN_EXCLUSIVE_INCLUSIVE)

                receive_mind!!.text = ssb
                receive_mind!!.movementMethod = LinkMovementMethod.getInstance()
            }
        }

    }

    override fun onClick(view: View) {
        when (view.id) {
            R.id.receive_view -> {
                //进入红包历史H5
                val h5Params = H5Params(HttpConfig.H5_URL+ "consult/bonus", null)
                NewH5Activity.start(mContext, h5Params)
            }
        }
    }

    override fun layoutResId(): Int {
        return R.layout.activity_receive_redpacket
    }

    /**
     * 初始化状态栏位置
     */
    private fun initStatus() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {//4.4以下不支持状态栏变色
            StatusBarUtils.setTransparentForImageView(this, null)
            val statusBarHeight = StatusBarUtils.getStatusBarHeight(this)
            val lp1 = title_bar.layoutParams as LinearLayout.LayoutParams
            lp1.height = (RxImageTool.dp2px(45f) + statusBarHeight)
            title_bar.setPadding(0, statusBarHeight, 0, 0)
        }
    }

    override fun initDataAndEvent() {
        initStatus()
        if (intent.hasExtra(PARAM)) {
            param = intent.getParcelableExtra(PARAM)
        }

        if (intent.hasExtra(PARAMSTR)) {
            val str = intent.getStringExtra(PARAMSTR)
            param = GsonProvider.getGson().fromJson<ReceiveRedPacketParam>(str,ReceiveRedPacketParam::class.java)
        }

        receive_view?.setOnClickListener(this)

/*        var bundle = intent.getBundleExtra("bundle")

        status = bundle.getInt("status", 0)

        money = bundle.getString("money")

        name = bundle.getString("name")

        headUrl = bundle.getString("headUrl")

        expertUrl = bundle.getString("expertUrl")

        expertName = bundle.getString("expertName")

        expertTime = bundle.getString("expertTime")*/

        init()
    }
}
