package com.yidianling.user.mine

import android.annotation.SuppressLint
import android.app.Activity
import android.app.Instrumentation
import android.content.Intent
import android.os.Bundle
import android.os.SystemClock
import android.text.Editable
import android.text.TextUtils
import android.text.TextWatcher
import android.view.MotionEvent
import android.view.View
import android.view.animation.Animation
import android.view.animation.AnimationUtils
import com.alibaba.android.arouter.facade.annotation.Route
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.utils.remind.HttpErrorUtils
import com.ydl.ydlcommon.utils.remind.ToastHelper
import com.ydl.ydlcommon.view.RoundCornerButton
import com.yidianling.common.tools.LogUtil
import com.yidianling.common.tools.ToastUtil
import com.yidianling.user.R
import com.yidianling.user.http.UserHttpImpl
import com.yidianling.user.mine.bean.RedPacketId
import com.yidianling.user.mine.bean.RedPacketIdCmd
import com.yidianling.user.mine.view.RedPacketGridView
import com.yidianling.ydl_pay.pay.PayActivity
import com.yidianling.ydl_pay.pay.PayParams
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers
import kotlinx.android.synthetic.main.activity_send_redpacket.*
import java.math.BigDecimal
import java.util.*


/**
 * Created by wi1ls on 2017/1/10.
 */
@Route(path = "/user/sendRedPacket")
class SendRedPacketActivity : BaseActivity(), View.OnClickListener, TextWatcher {

    override fun afterTextChanged(s: Editable?) {
        if (TextUtils.isEmpty(s.toString())) {
            tv_price_hint.text = "0.0"
            return
        }
        var str = s.toString()
        if (s.toString().startsWith(".")) {
            str = "0" + str
            LogUtil.d("change str: " + str)
        }
        LogUtil.d("str: " + str)
        var bd = BigDecimal(str)
        bd = bd.setScale(1, BigDecimal.ROUND_DOWN)
        tv_price_hint.text = bd.toString()
    }

    override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {
    }

    override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
    }

    companion object {
        fun newIntent(activity: Activity, toUid: String): Intent {
            val intent = Intent(activity, SendRedPacketActivity::class.java)
            val bundle = Bundle()
            bundle.putString("to_uid", toUid)
            intent.putExtra("bundle", bundle)
            return intent
        }
    }

    override fun getStatusViewOptions(): StatusBarOptions {
        val statusBarOptions = StatusBarOptions(true, true)
        statusBarOptions.statusColor = "#d3574c"
        return statusBarOptions
    }
    override fun layoutResId(): Int {
        return R.layout.activity_send_redpacket
    }

    override fun initDataAndEvent() {
        to_uid = if (intent.hasExtra("to_uid")){
            intent.getStringExtra("to_uid")
        }else{
            var bundle = intent.getBundleExtra("bundle")
            bundle.getString("to_uid")
        }
        init()
    }

    private val prices = ArrayList<String>()

    private var mChild: List<RoundCornerButton>? = null


    private var charge_money: Float? = null

    private var thanksTitle: String = "一点心意，请笑纳!"


    internal var to_uid: String? = null

    internal fun init() {

        rcb_next.setOnClickListener(this)

        initGV()

        recharge_et.addTextChangedListener(SendRedPacketActivity@ this)
        recharge_thanks_content.addTextChangedListener(object : TextWatcher {
            override fun afterTextChanged(s: Editable?) {
                thanksTitle = s.toString()
            }

            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {
            }

            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
            }

        })
        recharge_tv!!.setOnClickListener {
            recharge_tv!!.isClickable = false
            val translateAnimation = AnimationUtils.loadAnimation(this@SendRedPacketActivity, R.anim.recharge_text)
            recharge_tv!!.startAnimation(translateAnimation)
            translateAnimation.setAnimationListener(object : Animation.AnimationListener {
                override fun onAnimationStart(animation: Animation) {
                    for (i in mChild!!.indices) {
                        mChild!![i].setBg(-0x111112)
                        mChild!![i].setTextColor(-0x1000000)
                    }
                    charge_money = 0f
                }

                override fun onAnimationEnd(animation: Animation) {
                    recharge_et!!.visibility = View.VISIBLE
                    recharge_et!!.requestFocus()
                    recharge_et!!.setOnClickListener {
                        recharge_et!!.isCursorVisible = true
                        for (i in mChild!!.indices) {
                            mChild!![i].setBg(-0x111112)
                            mChild!![i].setTextColor(-0x1000000)
                        }
                        if (recharge_et.text.toString().isNullOrEmpty()){
                            charge_money = 0f
                            tv_price_hint.text = charge_money.toString()
                        }
                    }

                    val local = IntArray(2)
                    recharge_et!!.getLocationOnScreen(local)

                    val timer = Timer()
                    val timerTask = object : TimerTask() {
                        override fun run() {
                            val mInst = Instrumentation()
                            mInst.sendPointerSync(MotionEvent.obtain(SystemClock.uptimeMillis(),
                                    SystemClock.uptimeMillis(), MotionEvent.ACTION_DOWN, local[0].toFloat(), local[1].toFloat(), 0))    //x,y 即是事件的坐标
                            mInst.sendPointerSync(MotionEvent.obtain(SystemClock.uptimeMillis(),
                                    SystemClock.uptimeMillis(), MotionEvent.ACTION_UP, local[0].toFloat(), local[1].toFloat(), 0))

                        }
                    }
                    timer.schedule(timerTask, 500)
                }

                override fun onAnimationRepeat(animation: Animation) {

                }
            })
        }

    }

    private fun initGV() {
        prices.add("2元")
        prices.add("5元")
        prices.add("10元")
        prices.add("15元")
        prices.add("20元")
        prices.add("30元")

        recharge_rgv!!.setTexts(prices)
        charge_money = 2f
        mChild = recharge_rgv!!.childList
        mChild!![0].setBg(-0x2ca8b4)
        mChild!![0].setTextColor(-0x1)
        tv_price_hint.text = charge_money.toString()
        recharge_rgv!!.setItemClickListener(object : RedPacketGridView.ItemClickListener{
            override fun clickItem(view: View, position: Int) {
                recharge_rgv.requestFocus()
                if (recharge_et!!.visibility == View.VISIBLE) {
                    recharge_et!!.setText("")
                    recharge_et!!.isCursorVisible = false
                }
                for (i in mChild!!.indices) {
                    mChild!![i].setBg(-0x111112)
                    mChild!![i].setTextColor(-0x1000000)
                }
                charge_money = java.lang.Float.valueOf(prices.get(position).replace("元", ""))
                mChild!![position].setBg(-0x2ca8b4)
                mChild!![position].setTextColor(-0x1)
                tv_price_hint.text = charge_money.toString()
            }
        })
    }

    override fun onClick(view: View) {
        when (view.id) {
            R.id.rcb_next -> if (judge()) {
                //获取红包支付或者充值单号
                getRechageId()
            }
        }
    }

    /**
     * 获取充值单号
     */
    @SuppressLint("CheckResult")
    private fun getRechageId() {
        showProgressDialog("")
        val cmd = RedPacketIdCmd(to_uid, charge_money.toString(), thanksTitle)
        LogUtil.d("thanksTitle: $thanksTitle")
        UserHttpImpl.getInstance().getRedPacketId(cmd)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe({ resp ->
                    dismissProgressDialog()
                    try {
                        if (resp.code == 0) {
                            val redPacketId = resp.data as RedPacketId
                            val payParams = PayParams().apply {
                                type = PayParams.PAY
                                title = "红包"
                                LogUtil.d("title: " + title)
                                payId = redPacketId.payId.toString()
                                needPay = charge_money!!
                            }
                            this@SendRedPacketActivity.startActivityForResult(PayActivity.newIntent(this@SendRedPacketActivity, payParams), 44)

//                            YdlCommonOut.startPayActivity(this, payParams, 44)
//                            startActivityForResult(intent, 44)
                        } else {
                            ToastUtil.toastShort(resp.msg)
                        }
                    } catch (e: Throwable) {
                        LogUtil.d(e.message)
                    }
                }, { throwable ->
                    HttpErrorUtils.handleError(mContext, throwable)
                    dismissProgressDialog()
                })

    }

    /**
     * 判断是否符合金额要求
     *
     * @return
     */
    private fun judge(): Boolean {
        charge_money =tv_price_hint.text.toString().toFloat()
        if (charge_money!!.toFloat().compareTo(0f)<=0) {//输入的金额是空
            ToastUtil.toastShort("请输入金额")
            recharge_et!!.setText("")
            return false
        }
        if (charge_money.toString().compareTo("0.1") < 0) {
            ToastUtil.toastShort("红包金额不可低于0.1元")
            return false
        }
        return true
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (requestCode == 44 && resultCode == Activity.RESULT_OK) {
            ToastHelper.show("付款成功")
            finish()
        }
    }
}
