package com.yidianling.user.mine.data

import android.content.Context
import android.content.SharedPreferences
import com.ydl.ydlcommon.base.BaseApp

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/04/27
 */
internal class AppLocalImpl private constructor(): AppLocal {

    companion object {
        fun getInstance(): AppLocalImpl {
            return Holder.INSTANCE
        }

        private val APP = "app"
        private val RED_POCKET_TIME = "red_pocket_time"
        private val UPDATE = "update"
    }


    override fun getRedPocketTime(): Long {
        return getAppSP().getLong(RED_POCKET_TIME, 0)
    }

    override fun putRedPocketTime(time: Long) {
        getAppSP().edit().putLong(RED_POCKET_TIME, time).apply()
    }

    override fun hasUpdate(): Boolean {
        return getAppSP().getBoolean(UPDATE, false)
    }

    override fun putUpdate(update: Boolean) {
        getAppSP().edit().putBoolean(UPDATE, update).apply()
    }

    private fun getAppSP(): SharedPreferences {
        return BaseApp.getApp().getSharedPreferences(APP, Context.MODE_PRIVATE)
    }



    private object Holder {
        internal val INSTANCE = AppLocalImpl()
    }

}