package com.yidianling.user.mine.fragment


import android.annotation.SuppressLint
import android.app.Activity
import android.content.Intent
import android.text.TextUtils
import com.yidianling.user.mine.ChooseAccountActivity
import com.ydl.ydlcommon.base.BaseFragment
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlcommon.data.http.ThrowableConsumer
import com.ydl.ydlcommon.utils.TransferCacheUtils
import com.yidianling.common.tools.ToastUtil
import com.yidianling.user.R
import com.yidianling.user.mine.bean.AddAccountCmd
import com.yidianling.user.mine.data.AppDataManager
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.functions.Consumer
import kotlinx.android.synthetic.main.user_mine_fragment_add_ali_account.*


/**
 * 添加支付宝帐号
 */
class AddAliAccountFragment : BaseFragment() {

    override fun layoutResId(): Int {
        return R.layout.user_mine_fragment_add_ali_account
    }

    override fun initDataAndEvent() {
        btn_ensure.setOnClickListener {
            saveAccount()
        }
    }

    /**
     * 保存支付宝帐号
     */
    @SuppressLint("CheckResult")
    private fun saveAccount() {
        var account = et_account.text.trim().toString()
        if (TextUtils.isEmpty(account)) {
            ToastUtil.toastShort("支付宝帐号不能为空")
            return
        }
        var name = et_name.text.trim().toString()
        if (TextUtils.isEmpty(name)) {
            ToastUtil.toastShort("姓名不能为空")
            return
        }

        var param = AddAccountCmd(name, account, "1")
//        showProgressDialog("")
        AppDataManager.getHttp().addAccount(param)
                .compose(RxUtils.resultData())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(Consumer {
//                    dismissProgressDialog()
                    if (it == null) {
                        ToastUtil.toastShort("返回数据错误")
                    } else {
                        ToastUtil.toastShort("添加帐号成功")
                        var intent = Intent()
                        TransferCacheUtils.putTransferData(ChooseAccountActivity.ADD_ACCOUNT_REQUEST_CODE, it)
                        activity!!.setResult(Activity.RESULT_OK, intent)
                        activity!!.finish()
                    }
                }, object : ThrowableConsumer() {
                    override fun accept(msg: String) {
//                        dismissProgressDialog()
                        ToastUtil.toastShort(msg)
                    }
                })
    }

    override fun initDataAndEventLazy() {
    }

}
