package com.yidianling.user.mine.http

import com.ydl.ydlcommon.base.config.YDL_DOMAIN
import com.ydl.ydlcommon.base.config.YDL_DOMAIN_JAVA
import com.ydl.ydlcommon.bean.MustUP
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.yidianling.user.api.bean.UserResponseBean
import com.yidianling.user.bean.FundData
import com.yidianling.user.bean.Recharge
import com.yidianling.user.mine.bean.AccountBean
import com.yidianling.user.mine.bean.BalanceBean
import com.yidianling.user.mine.bean.CouponNumBean
import com.yidianling.user.mine.bean.FeedBackDetailBean
import io.reactivex.Observable
import okhttp3.RequestBody
import retrofit2.http.*

interface MineApi {
    //资金列表详情
    @FormUrlEncoded
    @POST("uc/mybalance")
    fun getMyFundList(@FieldMap params: Map<String, String>): Observable<BaseResponse<FundData>>

    //余额的接口
    @Headers( YDL_DOMAIN + YDL_DOMAIN_JAVA)
    @GET("auth/uc/myBalance")
    fun getMyBalance(): Observable<BaseResponse<BalanceBean>>

    //删除提现账号
    @FormUrlEncoded
    @POST("withdraw-account/delete")
    fun deleteAccount(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //提现账号编辑
    @FormUrlEncoded
    @POST("withdraw-account/edit")
    fun editAccount(@FieldMap params: Map<String, String>): Observable<BaseResponse<AccountBean>>

    /**
     * 其他
     */
    //反馈
    @Multipart
    @POST("uc/feedback")
    fun feedBack(@PartMap params: MutableMap<String, RequestBody>): Observable<BaseResponse<Any>>

    //获取投诉反馈详情
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    @GET("feedback/getDetail")
    fun getFeedBackDetail(@Query("id") id: String): Observable<BaseResponse<FeedBackDetailBean>>

    //获得充值单号
    @FormUrlEncoded
    @POST("pay/recharge")
    fun getRechargeId(@FieldMap params: Map<String, String>): Observable<BaseResponse<Recharge>>

    //设置为默认提现账号
    @FormUrlEncoded
    @POST("withdraw-account/set-default")
    fun setDefaultAccount(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //提现账号列表
    @FormUrlEncoded
    @POST("withdraw-account/list")
    fun getAccountList(@Field("holder_param") params: String): Observable<BaseResponse<MutableList<AccountBean>>>

    //申请提现
    @FormUrlEncoded
    @POST("withdraw/apply")
    fun applyAccount(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //提现账号添加
    @FormUrlEncoded
    @POST("withdraw-account/add")
    fun addAccount(@FieldMap params: Map<String, String>): Observable<BaseResponse<AccountBean>>

    //强制更新埋点
    @FormUrlEncoded
    @POST("site/cmd")
    fun appWillUp(@FieldMap params: Map<String, String>): Observable<BaseResponse<MustUP>>

    //获取是否有最新领用的优惠券
    @FormUrlEncoded
    @POST("sms/is-coupon-un-read")
    fun getNewCoupon(@FieldMap params: Map<String, String>): Observable<BaseResponse<CouponNumBean>>

    //获取用户信息
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    @POST("user/user_info")
    fun getUserInfo(@Body body: RequestBody): Observable<BaseAPIResponse<UserResponseBean>>

    //获得消息列表
    @FormUrlEncoded
    @POST("sms/list")
    fun getSysMsgList(@FieldMap params: Map<String, String>): Observable<BaseResponse<String>>

}