package com.yidianling.user.mine.view

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.widget.LinearLayout
import com.ydl.ydlcommon.view.RoundCornerButton
import com.yidianling.user.R
import java.util.*


/**
 * Created by Emma on 2016/8/5.
 */
class RedPacketGridView : LinearLayout {
    internal var mList: MutableList<RoundCornerButton> = ArrayList()


    //    @BindView(R.id.rcb_01)
    internal var rcb_01: RoundCornerButton?=null
    //    @BindView(R.id.rcb_02)
    internal var rcb_02: RoundCornerButton?=null
    //    @BindView(R.id.rcb_03)
    internal var rcb_03: RoundCornerButton?=null
    //    @BindView(R.id.rcb_04)
    internal var rcb_04: RoundCornerButton?=null
    //    @BindView(R.id.rcb_05)
    internal var rcb_05: RoundCornerButton?=null
    //    @BindView(R.id.rcb_06)
    internal var rcb_06: RoundCornerButton?=null

    private var itemClickListener: ItemClickListener? = null

    val childList: List<RoundCornerButton>
        get() = mList

    private fun initView() {
        rcb_01 = findViewById(R.id.rcb_01)
        rcb_02 = findViewById(R.id.rcb_02)
        rcb_03 = findViewById(R.id.rcb_03)
        rcb_04 = findViewById(R.id.rcb_04)
        rcb_05 = findViewById(R.id.rcb_05)
        rcb_06 = findViewById(R.id.rcb_06)
    }

    constructor(context: Context) : super(context) {
        View.inflate(context, R.layout.ui_recharge_gv, this)
        initView()
        init()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        View.inflate(context, R.layout.ui_recharge_gv, this)
        initView()
        init()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(context, attrs, defStyleAttr) {
        View.inflate(context, R.layout.ui_recharge_gv, this)
        initView()
        init()
    }

    internal fun init() {
        mList.clear()
        mList.add(rcb_01!!)
        mList.add(rcb_02!!)
        mList.add(rcb_03!!)
        mList.add(rcb_04!!)
        mList.add(rcb_05!!)
        mList.add(rcb_06!!)
        for (i in mList.indices) {
            mList[i].setStroke(0, 0x00000000)
        }
        setListener()
    }

    fun setFirstBg(c: Int) {
        rcb_01?.setBg(c)
    }


    fun setListener() {
        for (i in mList.indices) {
            mList[i].setOnClickListener { view ->
                if (itemClickListener != null)
                    itemClickListener!!.clickItem(view, i)
            }
        }
    }

    fun setItemClickListener(itemClickListener: ItemClickListener) {
        this.itemClickListener = itemClickListener
    }

    interface ItemClickListener {
        fun clickItem(view: View, position: Int)
    }

    fun setTexts(names: List<String>) {
        for (i in mList.indices) {
            mList[i].text = names[i]
        }
    }

}
