package com.yidianling.user.safePrivate


import android.app.Activity
import android.content.Intent
import android.text.TextUtils
import android.view.View
import android.widget.EditText
import android.widget.TextView
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.utils.StringUtils
import com.ydl.ydlcommon.utils.remind.HttpErrorUtils
import com.ydl.ydlcommon.view.TitleBar
import com.yidianling.common.tools.ToastUtil
import com.yidianling.user.R
import com.yidianling.user.UserHelper
import com.yidianling.user.bean.CheckPhonePassBean
import com.yidianling.user.http.UserHttpImpl
import com.yidianling.user.route.UserIn
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers
import kotlinx.android.synthetic.main.user_activity_check_password.*
/**
 * 验证登录密码
 */
class CheckPasswordActivity : BaseActivity() {
    override fun layoutResId(): Int {
        return R.layout.user_activity_check_password
    }

    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(true,true)
    }

    override fun initDataAndEvent() {
        type = intent.getStringExtra("type")

        initView()

        init()
    }

    var titBar: TitleBar? = null
    var textPhone: android.widget.TextView? = null
    var editPass: android.widget.EditText? = null
    var btn_next: TextView? = null

    //密码验证成功后的跳转类型
    var type: String? = null

    //跳转来源

    companion object {

        fun startActivity(activity: Activity) {
            activity.startActivity(Intent(activity, CheckPasswordActivity::class.java))
        }

        fun startActivity(activity: Activity, type: String) {
            val intent = Intent(activity, CheckPasswordActivity::class.java)
            intent.putExtra("type", type)
            activity.startActivity(intent)
        }
    }


    fun initView() {
        titBar = findViewById<TitleBar>(R.id.title_bar)
        textPhone = findViewById<TextView>(R.id.text_phoneNumber)
        editPass = findViewById<EditText>(R.id.edit_pass)
        btn_next = findViewById<TextView>(R.id.btn_next)
    }

    fun init() {
        var userPhone = UserHelper.getUserInfo()?.userInfo?.phone
        if (userPhone !=null && userPhone.length == 11) {
            userPhone = userPhone.substring(0, 3) + "****" + userPhone.substring(7, 11)
        }
        textPhone?.setText(userPhone)

        btn_next?.setOnClickListener {
            //向服务器验证用户密码
            val string = editPass?.text.toString()
            if (TextUtils.isEmpty(string)) {
                ToastUtil.toastShort("密码不能为空")
            } else {
                showProgressDialog(null)
                val cmd = CheckPhonePassBean(StringUtils.md5(string))
                UserHttpImpl.getInstance().checkPhonePass(cmd)
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe({ s ->
                            dismissProgressDialog()
                            if (s.code==0){
                                val check = s.data
                                if (check.result == 1) {//1正确，0密码错误
                                    if (type == "") {
                                        //进入启动页
//                                        UserIn.startSplash(mContext)
                                        UserIn.splashIntent(this)
                                        finish()
                                    } else {
                                        //跳转手势密码设置界面
                                        startActivity(android.content.Intent(mContext, SetHandUnLockActivity::class.java))
                                        finish()
                                    }
                                } else {
                                    ToastUtil.toastShort("密码错误")
                                }
                            }else{
                                ToastUtil.toastShort(s.msg)
                            }

                        }, { t ->
                            dismissProgressDialog()
                            HttpErrorUtils.handleError(mContext, t)
                        })
            }
        }

        editPass?.requestFocus()
        //自动弹出键盘
//        InputMethonUtils.showSoftInputFromWindow(mContext,editPass)
    }

    override fun showProgressDialog(str: String?) {
        pb_load.visibility = View.VISIBLE
    }

    override fun dismissProgressDialog() {
        pb_load.visibility = View.GONE
    }

}
