package com.yidianling.user.safePrivate

import androidx.core.content.ContextCompat
import android.view.View
import android.widget.TextView
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.utils.ActivityManager
import com.ydl.ydlcommon.view.TitleBar
import com.ydl.ydlcommon.view.dialog.CommonDialog
import com.ydl.ydlcommon.view.shoushi.Lock9View
import com.ydl.ydlcommon.view.shoushi.LockIndicator
import com.yidianling.common.tools.ToastUtil
import com.yidianling.user.R
import com.yidianling.user.UserHelper

/**
 * 设置手势解锁界面
 */
class SetHandUnLockActivity : BaseActivity() {
    override fun layoutResId(): Int {
        return R.layout.user_activity_hand_unlock_set
    }

    override fun initDataAndEvent() {
        init()
    }
    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(true,true)
    }

    var titleBar: TitleBar? = null
    var tip_bar: LockIndicator? = null
    var tipText: TextView? = null
    var lock9: Lock9View? = null

    //第一次设置的密码
    var first_pass: String? = null

    fun init() {
        titleBar = findViewById<TitleBar>(R.id.title_bar) as TitleBar
        tip_bar = findViewById<LockIndicator>(R.id.tip_bar) as LockIndicator
        tipText = findViewById<TextView>(R.id.text_tip) as TextView
        lock9 = findViewById<Lock9View>(R.id.lock9View) as Lock9View

        titleBar?.setRightTextColor(ContextCompat.getColor(this, R.color.platform_main_theme))
        titleBar?.setRightTextVisiable(View.GONE)

        titleBar?.setLeftImageListener {
            onBackPressed()
        }

        titleBar?.setOnRightTextClick { _, _ ->
            //重新绘制
            first_pass = null
            tipText?.visibility = View.INVISIBLE
            tip_bar?.setPath(null)
            lock9?.reSet()
            lock9?.setSuccessPass(null)
        }

        lock9?.setCallBack(object : Lock9View.CallBack {
            override fun onStart() {
                if (first_pass != null) {
                    tipText?.setText("")
                    tipText?.setTextColor(ContextCompat.getColor(this@SetHandUnLockActivity, R.color.platform_tag_text))
                }
            }

            override fun onFinish(password: String) {

                if (first_pass == null) {
                    //提示再次输入
                    if (password.length < 4) {
                        ToastUtil.toastShort("不能少于4个连接点")
                        return
                    }
                    lock9?.setSuccessPass(password)
                    tipText?.visibility = View.VISIBLE
                    tipText?.setText("再次绘制图案进行确认")
                    tipText?.setTextColor(ContextCompat.getColor(this@SetHandUnLockActivity, R.color.platform_tag_text))
                    titleBar?.setRightTextVisiable(View.VISIBLE)
                    first_pass = password
                    tip_bar?.setPath(password)
                } else {
                    if (password.length < 4) {
                        ToastUtil.toastShort("不能少于4个连接点")
                        return
                    }
                    //第二次输入--判断与第一次是否一致
                    if (password.equals(first_pass)) {
                        //手势密码设置成功
                        lock9?.setSuccessPass(null)
                        FingerPrintUtil.instance().setHandPassword(password)
                        ToastUtil.toastShort("设置成功")
                        //关闭手势解锁页面与指纹解锁页面
                        ActivityManager.getInstance().finishActivity(FingerPrintCheckActivity::class.java)
                        ActivityManager.getInstance().finishActivity(HandUnlockCheckActivity::class.java)
                        FingerPrintUtil.instance().setCurrentUnLockTime(System.currentTimeMillis())
                        //隐藏红点
                        UserHelper.getUsetSetting()?.meSafePrivateIsClick = true
                        finish()
                    } else {
                        //与上次密码不一致，请重新绘制
                        tipText?.text = "与上次输入不一致，请重新绘制"
                        tipText?.setTextColor(ContextCompat.getColor(this@SetHandUnLockActivity, R.color.platform_price_color))
                    }
                }
            }
        })
    }

    override fun onBackPressed() {
        CommonDialog(mContext)
                .setMessage("\n确认退出手势设置流程吗\n")
                .setLeftOnclick("取消", {})
                .setRightClick("退出", {
                    finish()
                })
                .setCancelAble(false)
                .show()
    }

}
