package com.yidianling.user.ui.login;

import android.content.Context;
import android.content.Intent;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;

import com.ydl.ydlcommon.base.BaseActivity;
import com.ydl.ydlcommon.base.BaseApp;
import com.ydl.ydlcommon.bean.StatusBarOptions;
import com.yidianling.common.tools.RxNetTool;
import com.yidianling.user.R;

import org.jetbrains.annotations.NotNull;

/**
 * @author jiucheng
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/11/9
 * <p>
 * 登录注册页面逻辑中有隐私和用户协议的h5页面，样式、动画和
 * [com.ydl.ydlcommon.h5.NewH5Activity]
 * 不一样，没办法复用
 */
public class H5Activity extends BaseActivity {
    private static final String INTENT_PRIVACY = "intent_privacy";

    @NotNull
    @Override
    public StatusBarOptions getStatusViewOptions() {
        return new StatusBarOptions(true,true);
    }

    @Override
    protected void initDataAndEvent() {
        WebView web_view = findViewById(R.id.web_view);
        ImageView iv_pop = findViewById(R.id.iv_pop);
        iv_pop.setOnClickListener(view -> {
            finish();
            overridePendingTransition(0, R.anim.platform_slide_out_to_bottom);
        });
        web_view.setWebViewClient(new WebViewClient() {
            //覆盖shouldOverrideUrlLoading 方法
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                view.loadUrl(url);
                return true;
            }
        });
        web_view.getSettings().setJavaScriptEnabled(true);
        web_view.getSettings().setAppCacheEnabled(true);
        //设置 缓存模式
        web_view.getSettings().setCacheMode(WebSettings.LOAD_DEFAULT);
        // 开启 DOM storage API 功能
        web_view.getSettings().setDomStorageEnabled(true);
        if (getIntent().getBooleanExtra(INTENT_PRIVACY, false)) {
            //隐私政策
            if (!RxNetTool.isConnected(BaseApp.Companion.getApp())){
                //无网络 读取本地文件
                web_view.loadUrl("file:///android_asset/html/yinsi.html");
            }else {
                web_view.loadUrl("https://m.ydl.com/Protol/yinsi");//加载url
            }
        } else {
            //用户协议0
            if (!RxNetTool.isConnected(BaseApp.Companion.getApp())){
                //无网络 读取本地文件
                web_view.loadUrl("file:///android_asset/html/sdkuserprotol.html");
            }else {
                web_view.loadUrl("https://h5.ydl.com/SDUserProtol");//加载url
            }
        }
    }

    @Override
    protected int layoutResId() {
        return R.layout.user_activity_h5;
    }


    @Override
    public void onBackPressed() {
        finish();
        overridePendingTransition(0, R.anim.platform_slide_out_to_bottom);
    }

    /**
     * @param context
     * @param userPrivacy 是否是用户隐私协议
     */
    public static void start(Context context, boolean userPrivacy) {
        Intent starter = new Intent(context, H5Activity.class);
        starter.putExtra(INTENT_PRIVACY, userPrivacy);
        context.startActivity(starter);
    }


}
