package com.yidianling.user.ui.login

import android.app.Activity
import android.content.Intent
import android.os.Build
import android.text.Html
import android.view.KeyEvent
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.utils.SharedPreferencesEditor
import com.ydl.ydlcommon.utils.StatusBarUtils
import com.yidianling.user.R
import com.yidianling.user.widget.SecretDialog
import kotlinx.android.synthetic.main.user_activity_secret.*

/**
 * 隐私界面
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/01/10
 */
class SecretActivity : BaseActivity() {

    private var secretDialog: SecretDialog? = null
    private var mSecretProtocolString: String = ""

    companion object {
        val SECRET_PROTOCOL: String = "secret_protocol"
        val SECRET_PAGE_REQUEST_CODE: Int = 42
        val SECRET_PAGE_REQUEST_OK_CODE: Int = 43
        val SECRET_PAGE_REQUEST_FAILURE_CODE: Int = 44

        fun startProtocol(context: Activity, secretProtocolString: String) {
            val intent = Intent(context, SecretActivity::class.java)
            intent.putExtra(SECRET_PROTOCOL, secretProtocolString)
            context.startActivityForResult(intent, SECRET_PAGE_REQUEST_CODE)
        }
    }
    
    override fun layoutResId(): Int {
        return R.layout.user_activity_secret
    }

    override fun initDataAndEvent() {

        getParam()
        initView()
    }

    private fun getParam() {
        mSecretProtocolString = intent.getStringExtra(SECRET_PROTOCOL) ?: ""
        if (null != user_secret_desc) {
            user_secret_desc.text = Html.fromHtml(mSecretProtocolString)
        }
    }

    private fun initView() {

        initStatus()

        user_secret_no_agree.setOnClickListener {
            if (null == secretDialog) {
                secretDialog = SecretDialog(this, object : SecretDialog.OnSecretDialogListener {
                    override fun onCancel() {
                        setResult(SECRET_PAGE_REQUEST_FAILURE_CODE)
                        finish()
                    }

                    override fun onSure() {
                        agreeAction()
                    }
                })
                secretDialog?.show()
            } else {
                secretDialog?.show()
            }
        }

        user_secret_agree.setOnClickListener {
            agreeAction()
        }

        user_use_btn.setOnClickListener {
            H5Activity.start(this@SecretActivity, false)
        }

        user_secret_protect_btn.setOnClickListener {
            H5Activity.start(this@SecretActivity, true)
        }
    }

    override fun onKeyDown(keyCode: Int, event: KeyEvent): Boolean {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            return false
        }
        return super.onKeyDown(keyCode, event)
    }

    private fun initStatus() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {//4.4以下不支持状态栏变色
            StatusBarUtils.setTransparentForImageView(this, null)
            StatusBarUtils.statusBarLightMode(this)
        }
    }

    private fun agreeAction() {
        SharedPreferencesEditor.putString("hasAgreeSecret", "true")
        setResult(SECRET_PAGE_REQUEST_OK_CODE)
        finish()
    }
}