package com.yidianling.user.widget

import android.content.Context
import android.graphics.Color
import android.util.AttributeSet
import android.view.Gravity
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import com.ydl.ydl_router.manager.YDLRouterManager
import com.ydl.ydl_router.manager.YDLRouterParams
import com.ydl.ydlcommon.router.IYDLRouterConstant
import com.yidianling.common.tools.RxImageTool
import com.yidianling.user.R

/**
 * @author yuanWai
 * @描述:提现申请通知提示View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/1/25
 */
class WithDrawTipsView : LinearLayout {

    private var dp14 : Int = 0
    private var dp15 : Int = 0
    private var dp85  : Int = 0
    private var dp4  : Int = 0
    private var dp12 : Int = 0

    init {
        dp14 = RxImageTool.dip2px(14f)
        dp15 = RxImageTool.dip2px(15f)
        dp85 = RxImageTool.dip2px(8.5f)
        dp4 = RxImageTool.dip2px(4f)
        dp12 = RxImageTool.dip2px(12f)
    }

    constructor(context: Context) : super(context) {
        initView()
    }

    constructor(context: Context, attributeSet: AttributeSet) : super(context, attributeSet) {
        initView()
    }

    /**
     * 界面初始化
     */
    private fun initView() {
        val params = ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, RxImageTool.dip2px(32f))
        layoutParams = params
        setBackgroundResource(R.color.platform_color_FFEEE6)
        orientation = HORIZONTAL
        removeAllViews()
        addImageView()
        addMsgView()
        setOnClickListener {
            YDLRouterManager.router(IYDLRouterConstant.ROUTER_H5_H5, YDLRouterParams().putExtra(IYDLRouterConstant.EXTRA_URL,"https://static.ydlcdn.com/v4/announce/app/html/index.html"))
        }
    }

    private fun addImageView(){
        val image = ImageView(context)
        image.setImageResource(R.drawable.app_redpacket_tixing)
        val imageParams = LinearLayout.LayoutParams(dp14,dp14)
        imageParams.setMargins(dp15,dp85,0,0)
        image.layoutParams = imageParams
        addView(image)
    }

    private fun addMsgView(){
        val msgView = TextView(context)
        msgView.gravity = Gravity.CENTER_VERTICAL
        msgView.text = "2月份提现时间提前通知"
        msgView.setTextColor(Color.parseColor("#ff821d"))
        msgView.textSize = 12f
        val msgParams = LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT,ViewGroup.LayoutParams.MATCH_PARENT)
        msgParams.setMargins(dp4,0,0,0)
        msgView.layoutParams = msgParams
        addView(msgView)
    }
}