package com.yidianling.user.api.bean

import com.google.gson.annotations.SerializedName
import com.yidianling.user.api.utils.UserApiServiceUtils


/**
 * author : hgw
 * time   : 2018/02/02
 */
class UserResponseBean {

    var uid: String? = null
    var accessToken: String? = null
    var firstLogin: Int = 0 //1是 2否
    var hxpwd: String? = null
    var userInfo: UserResponseBean.UserInfo? = UserInfo()
        set(value) {
            field = value
            UserApiServiceUtils.provideUserApiService().setUserResponse(this)
        }

    inner class UserInfo {
        var uid: String = "0"
        @field:SerializedName("userName")
        var user_name: String? = null
        var accessToken: String? = null//
        @field:SerializedName("bindPhone")
        var bind_phone: Int? = 0 //1为绑定
        var phone: String? = null
        @field:SerializedName("realName")
        var real_name: String? = null
        @field:SerializedName("nickName")
        var nick_name: String? = null
        var head: String? = null
        var gender: Int = 0//性别1男2女

        var birthday: String? = null

        @field:SerializedName("availableMoney")
        var available_money: String? = null
        var address: String? = null
        @field:SerializedName("unionId")
        var union_id: String? = null//微信标识，
        @field:SerializedName("openIdQqweb")
        var open_id_qqapp: String? = null//qq标识
        @field:SerializedName("bindWeixin")
        var bind_weixin: Int = 0 //是否绑定微信1绑定0未绑定

            set(value) {
                if (value != bind_weixin) {
                    field = value
                    UserApiServiceUtils.provideUserApiService().updateUserInfoSp(this)
                }
            }
        @field:SerializedName("bindQq")
        var bind_qq: Int = 0
            //是否绑定qq 1绑定0未绑定
            set(value) {
                if (value != bind_qq) {
                    field = value
                    UserApiServiceUtils.provideUserApiService().updateUserInfoSp(this)
                }
            }
        @field:SerializedName("userType")
        var user_type: Int = 0//1普通用户2心理专家
        @field:SerializedName("listenCards")
        var listen_cards: Int = 0//收听卡的次数
        var profession: Int = 0
            set(value) {
                if (value != profession) {
                    field = value
                    UserApiServiceUtils.provideUserApiService().updateUserInfoSp(this)
                }
            }
        var marriage: Int = 0
            set(value) {
                if (value != marriage) {
                    field = value
                    UserApiServiceUtils.provideUserApiService().updateUserInfoSp(this)
                }
            }
        @field:SerializedName("countryCode")
        var country_code: String? = null
        @field:SerializedName("homeBg")
        var home_bg: String? = null
            //我的封面地址
            set(value) {
                if (!(value?.equals(home_bg) ?: false)) {
                    field = value
                    UserApiServiceUtils.provideUserApiService().updateUserInfoSp(this)
                }
            }
        //是否同意过隐私权限 1同意过  0未同意
        var privacyAgreementStatus: Int = 1
            set(value) {
                if (value != privacyAgreementStatus) {
                    field = value
                    UserApiServiceUtils.provideUserApiService().updateUserInfoSp(this)
                }
            }

        var description: String? = null
            //简介
            set(value) {
                if (!(value?.equals(description) ?: false)) {
                    field = value
                    UserApiServiceUtils.provideUserApiService().updateUserInfoSp(this)
                }
            }
        @field:SerializedName("isSilenced")
        var is_silenced: Int = 0 // 1 正常 2 禁言
            set(value) {
                if (value != is_silenced) {
                    field = value
                    UserApiServiceUtils.provideUserApiService().updateUserInfoSp(this)
                }
            }
        var hasCoupon: Int = 0
        var firstLogin: Int = 0 //1是2否
            set(value) {
                if (value != firstLogin) {
                    field = value
                    UserApiServiceUtils.provideUserApiService().updateUserInfoSp(this)
                }
            }

        var trendNum: Int = 0 //我的动态
            set(value) {
                if (value != trendNum) {
                    field = value
                    UserApiServiceUtils.provideUserApiService().updateUserInfoSp(this)
                }
            }

        var fansNum: Int = 0
            //我的粉丝
            set(value) {
                if (value != fansNum) {
                    field = value
                    UserApiServiceUtils.provideUserApiService().updateUserInfoSp(this)
                }
            }
        var testRecordNum: Int = 0
            //测试记录
            set(value) {
                if (value != testRecordNum) {
                    field = value
                    UserApiServiceUtils.provideUserApiService().updateUserInfoSp(this)
                }
            }
        var attentionNum: Int = 0
            //我的关注
            set(value) {
                if (value != attentionNum) {
                    field = value
                    UserApiServiceUtils.provideUserApiService().updateUserInfoSp(this)
                }
            }
        var registTime: String? = null
            //你我相识已502天
            set(value) {
                if (!(value?.equals(registTime) ?: false)) {
                    field = value
                    UserApiServiceUtils.provideUserApiService().updateUserInfoSp(this)
                }
            }

        var privacyArr: PrivacyArr? = null

        override fun toString(): String {
            return "UserInfo(uid='$uid', user_name=$user_name, accessToken=$accessToken, bind_phone=$bind_phone, phone=$phone, real_name=$real_name, nick_name=$nick_name, head=$head, gender=$gender, birthday=$birthday, available_money=$available_money, address=$address, union_id=$union_id, open_id_qqapp=$open_id_qqapp, bind_weixin=$bind_weixin, bind_qq=$bind_qq, user_type=$user_type, listen_cards=$listen_cards, profession=$profession, marriage=$marriage, country_code=$country_code, home_bg=$home_bg, description=$description, is_silenced=$is_silenced, hasCoupon=$hasCoupon, firstLogin=$firstLogin, trendNum=$trendNum, fansNum=$fansNum, testRecordNum=$testRecordNum, attentionNum=$attentionNum, registTime=$registTime)"
        }
    }


    inner class PrivacyArr {
        var time: String? = null
        var content: String? = null
    }

    override fun toString(): String {
        return "UserResponseBean(uid=$uid, accessToken=$accessToken, firstLogin=$firstLogin, hxpwd=$hxpwd, userInfo=$userInfo)"
    }

}