package com.yidianling.user.api.service

import android.app.Activity
import android.content.Context
import android.content.Intent
import androidx.fragment.app.Fragment
import com.alibaba.android.arouter.facade.template.IProvider
import com.yidianling.user.api.bean.UserResponseBean
import com.yidianling.user.api.bean.UserSettingBean
import com.yidianling.user.api.listener.SecretDataListener
import com.yidianling.user.api.listener.UserInfoFromApiListener
import com.yidianling.user.api.listener.VersionUpdateStatusListener

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/04/13
 */
interface IUserService : IProvider {

    // 是否已登录
    fun isLogin(): Boolean

    fun isFirstLogin(): Boolean

    fun setFirstLogin(first: Boolean)

    fun isSafePrivacyClicked(): Boolean

    fun putSafePrivacyClicked(clicked: Boolean)

    fun setUserResponse(userInfo: UserResponseBean?)

    fun getUserInfo(): UserResponseBean.UserInfo?

    fun getUserInfoFromApi(listener: UserInfoFromApiListener)

    fun setUserInfo(userInfo: UserResponseBean.UserInfo?)

    fun getUserResponse() : UserResponseBean?

    fun getUserSetting(): UserSettingBean?

    fun isBindPhone(): Boolean

    fun putUnlockCheckSuccessTime(time: Long)

    fun getChatTeamHisShow(): Boolean

    fun setChatTeamHisShowed(showed : Boolean)

    // 跳转到隐私界面的 Activity
    fun privacyIntent(activity: Activity): Intent

    fun loginWayIntent(context: Context): Intent

    fun inputPhoneIntent(activity: Activity, smsAction: String): Intent

    fun safeTipViewGone(): Boolean

    fun setTrendsSafeTip(status: Boolean)

    fun errorAgainTime(): Long

    fun isFirstStart(): Boolean

    fun updateUserInfoSp(userInfo: UserResponseBean.UserInfo?)

    fun updateUserSetingSp(userSetting: UserSettingBean?)

    fun clearUserInfo()

    fun getMineFragment(): Fragment

    fun updateUI(fragment: Fragment)

    fun checkUpVersion(activity: Activity, listener: VersionUpdateStatusListener)

    fun getRedPocketTime(): Long

    fun putRedPocketTime(time: Long)

    fun hasUpdate(): Boolean

    fun hasPrivacyDialog(): Boolean //判断单例的隐私弹框是否为空

    fun initPrivacyDialog(activity: Activity, content: String, time: String) //初始化隐私弹框

    fun showPrivacyDialog()

    fun privacyDialogIsShow(): Boolean

    fun loginUtilsLogout()

    fun setChannelId()

    fun logoutlearLocal()

    fun shouldShowFingerPage(activity: Activity) //app从后台进入前台， 判定是否跳转解锁页面

    fun shouldShowFingerPageFromKill(activity: Activity, isSplashActivity: Boolean) //启动app，判定是否跳转解锁页面

    fun wxBindToInputhonePage(activity: Activity)

    fun getSecretPageRequestOkCode(): Int

    fun getSecretDataApi(activity: Activity, listener: SecretDataListener)

    fun startFromGuide(context: Context, isBindPhone: Boolean, isFromGudile: Boolean)

    /**
     * 调用优先使用一键登录，并返回调用时的登录状态，
     * @param isOpenDialog true:一键登录使用弹窗展示 false:一键登录使用全屏模式
     * @return true：已登录，不触发登录跳转，false：未登录，优先一键登录
     * */
    fun loginByOneKeyLogin(context: Context, isOpenDialog: Boolean) :Boolean
}