package com.ydl.media.audio.utils

import android.content.Context
import android.text.TextUtils

/**
 * 工具类
 * Created by hgw on 2018/3/31.
 */
object PlayProgressUtil {

    /**
     * 保存播放进度
     */
    fun saveProgress(context: Context?,url : String?,progress : Int){
        if (TextUtils.isEmpty(url))return
        var shared = context?.getSharedPreferences("AUDIO_PLAYER_MUSIC_PROGRESS",Context.MODE_PRIVATE)
        var edit = shared?.edit()
        edit?.putInt(url,progress)
        edit?.commit()
    }

    /**
     * 获取进度
     */
    fun getProgress(context: Context?,url : String?):Int{
        if (TextUtils.isEmpty(url))return 0
        var shared = context?.getSharedPreferences("AUDIO_PLAYER_MUSIC_PROGRESS",Context.MODE_PRIVATE)
        return shared?.getInt(url,0)?:0
    }
}