package com.ydl.ydlcommon.actions.imagepicker

import androidx.appcompat.app.AppCompatActivity
import com.luck.picture.lib.PictureSelector
import com.luck.picture.lib.config.PictureMimeType
import com.luck.picture.lib.listener.OnResultCallbackListener


/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/05/07
 */
object YDLImagePicker {


    fun startPicker(activity: AppCompatActivity, callback: OnResultCallbackListener) {
        startPicker(activity,1,callback)
    }

    fun startPicker(activity: AppCompatActivity, maxSelectNum :Int,callback: OnResultCallbackListener) {
        PictureSelector.create(activity)
            .openGallery(PictureMimeType.ofImage())
            .maxSelectNum(maxSelectNum)
            .compress(true)
            .minimumCompressSize(100)
            .isWeChatStyle(true)
            .loadImageEngine(GlideEngine.createGlideEngine())
            .forResult(callback)
    }

}