package com.ydl.ydlcommon.adapter;

import android.widget.BaseAdapter;

import com.yidianling.common.tools.LogUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * 通用适配器
 * Created by Dog on 2015/6/22.
 */
abstract public class CommonAdapter<T> extends BaseAdapter {
    public List<T> mDataList = new ArrayList<>();

    public void setDataList(List<T> dataList) {
//        this.mDataList = dataList;
        this.mDataList.clear();
        this.mDataList.addAll(dataList);
        if (mDataList.size() > 0) {
            notifyDataSetChanged();
        }
    }

    public void addDataList(int position, List<T> dataList) {

        this.mDataList.addAll(position, dataList);
        notifyDataSetChanged();
    }

    public void addDataList(List<T> dataList) {

        this.mDataList.addAll(dataList);
        notifyDataSetChanged();
    }

    public void addData(T data) {
        this.mDataList.add(data);
        notifyDataSetChanged();
    }

    public void update(List<T> data){
        this.mDataList.clear();
        this.mDataList.addAll(data);
        notifyDataSetChanged();
    }

    public void addData(int positoin, T data) {

        this.mDataList.add(positoin, data);
        notifyDataSetChanged();
    }

    public void clearData() {
        if (this.mDataList == null)
            return;
        this.mDataList.clear();
        notifyDataSetChanged();
    }

    public void removeData(int position) {
        if (position >= mDataList.size()) {
            LogUtil.e("越界访问");
            return;
        }

        this.mDataList.remove(position);
        notifyDataSetChanged();
    }

    public void removeData(T data) {
        mDataList.remove(data);
        notifyDataSetChanged();
    }

    public List<T> getDataList() {
        return mDataList;
    }

    @Override
    public int getCount() {
        return mDataList == null ? 0 : mDataList.size();
    }

    @Override
    public Object getItem(int position) {
        return mDataList.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }
}
