package com.ydl.ydlcommon.data.http

import com.yidianling.common.tools.RxDeviceTool
import com.ydl.ydlcommon.base.BaseApp
import com.ydl.ydlcommon.data.PlatformDataManager
import com.ydl.ydlcommon.modular.ModularServiceManager

/**
 * 基础网络请求类
 * Created by Dog on 2015/5/8.
 */
open class BaseCommand {
    @JvmField
    var uid = "0"
    @JvmField
    var accessToken = ""
    @JvmField
    var ts: String
    @JvmField
    var version: String
    @JvmField
    var osBuild =
        RxDeviceTool.getBuildMANUFACTURER() + "," + RxDeviceTool.getBuildBrandModel() + "," + RxDeviceTool.getOsBuileVersion() + "," + RxDeviceTool.getAppVersionName(
            BaseApp.getApp()
        )
    @JvmField
    var isFromApp = "1"//2表示专家版1表示用户版
    @JvmField
    var ffrom = PlatformDataManager.getRam().getChannelName()//渠Y道来源

    init {
        val userInfo = ModularServiceManager.getPlatformUserService()?.getUser()
        if (userInfo != null) {
            uid = userInfo.userId
            accessToken = userInfo.token
        }
        ts = (System.currentTimeMillis() / 1000).toString() + ""
        version = RxDeviceTool.getAppVersionName(BaseApp.getApp())

    }

}