package com.ydl.ydlcommon.utils

import android.annotation.SuppressLint
import android.app.Activity
import android.app.Dialog
import android.os.Bundle
import android.text.method.ScrollingMovementMethod
import android.view.View
import android.view.ViewGroup
import com.ydl.ydlcommon.R
import com.ydl.ydlcommon.bean.VersionData
import com.yidianling.common.tools.RxDeviceTool
import io.reactivex.Observable
import io.reactivex.android.schedulers.AndroidSchedulers
import kotlinx.android.synthetic.main.platform_dialog_update_layout.*


/**
 * app升级
 * 兼容8.0系统
 */
class ApkUpdateDialog : Dialog{

    private var listener: ApkInstallTool.UpdateProgressListener? = null

    private var updateData : VersionData? = null

    private var activity : Activity? = null

    private var isCancleAble : Boolean = true

    private var apkIns : ApkInstallTool? = null

    private var Temp_Online_time = "2019-07-16 15:00:00" //假设是这个日期上线，为了弥补交互逗比需求

    constructor(activity: Activity?) : super(activity){
        this.activity = activity
    }

    @SuppressLint("SetTextI18n")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.platform_dialog_update_layout)

        tv_update_content.text = updateData?.title
        tv_update_content.movementMethod = ScrollingMovementMethod.getInstance();

        text_version.text = "v${updateData?.ver}"
        text_desc.text = updateData?.content
        text_desc.movementMethod = ScrollingMovementMethod.getInstance();

        v_downpress.setSize(28,14,6,9,4)
        v_downpress.setTextSize(10)
//        v_downpress.setProgress(0)

        listener = object : ApkInstallTool.UpdateProgressListener {
            @SuppressLint("CheckResult")
            override fun startLoad() {
                Observable.just(1)
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe({
                            tv_title.text = "新版本下载中"
                            text_version.visibility = View.GONE
                            tv_bottom_desc.text = "新版本正在努力更新中,请稍等"
                            lin_progress.visibility = View.VISIBLE
                            tv_confirm.visibility = View.GONE
                            lin_content.visibility = View.GONE
                            lin_sure.visibility = View.GONE
                        },{})
            }

            @SuppressLint("CheckResult")
            override fun progress(progress: Int) {
                Observable.just(1)
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe({
                            progress_bar.progress = progress
                            v_downpress.setProgress(progress)
                        },{})
            }
        }

        apkIns = ApkInstallTool()

        tv_confirm.setOnClickListener {
            //开始下载
            if(updateData?.installLink==null)return@setOnClickListener
            apkIns?.start(activity,updateData,listener)
        }

        if ("1" == updateData?.updateFlag){
            iv_close.visibility = View.GONE
        }else{
            iv_close.setOnClickListener {
                //取消下载
                apkIns?.cancleDown()
                if (tv_confirm.visibility == View.GONE){
                    //启动后台service下载
                    SystemDownloadFileUtil.getInstances(context).setUrl(updateData?.installLink).setVersion(updateData?.ver).start()
                }
                dismiss()
            }
        }
    }

    override fun onStart() {
        super.onStart()
        val padding = context.resources.getDimensionPixelSize(R.dimen.platform_default_dis_size_big)
        window.setLayout(
                RxDeviceTool.getScreenWidth(context) - padding, ViewGroup.LayoutParams.WRAP_CONTENT
        )
        window.setBackgroundDrawableResource(R.color.platform_transparent)
        setCancelable(isCancleAble)
        setCanceledOnTouchOutside(false)

    }
    fun setData(data : VersionData?): ApkUpdateDialog {
        updateData = data
        return this
    }

    /**
     * 是否允许取消
     */
    fun setCancle(cancleable : Boolean): ApkUpdateDialog {
        this.isCancleAble = cancleable
        return this
    }

    override fun show() {
        if (null == activity || activity!!.isFinishing){
            return
        }
        super.show()
    }
}