package com.ydl.ydlcommon.utils

import android.os.Looper

import io.reactivex.Observable
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers

/**
 * Created by haorui on 2019/4/19.
 * Des:
 */
object ThreadUtils {

    val isMainThread: Boolean
        get() = Looper.myLooper() == Looper.getMainLooper()

    //主线程做操作
    fun doOnUIThread(uiTask: UITask) {
        Observable.just(uiTask)
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe { uiTask1 -> uiTask1.doOnUI() }

    }

    //io线程做操作
    fun doOnThread(threadTask: ThreadTask) {
        Observable.just(threadTask)
                .observeOn(Schedulers.io())
                .subscribe { threadTask1 -> threadTask1.doOnThread() }
    }

    interface ThreadTask {
        fun doOnThread()
    }

    interface UITask {
        fun doOnUI()
    }
}
