package com.ydl.ydlcommon.utils;

import android.annotation.TargetApi;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.Html;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.view.Display;
import android.view.WindowManager;
import android.widget.TextView;

import com.ydl.ydlcommon.base.BaseApp;
import com.ydl.ydlcommon.view.CenterAlignImageSpan;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;


public class Utils {
    private static long lastClickTime;

    public synchronized static boolean isFastClick() {
        long time = System.currentTimeMillis();
        if (time - lastClickTime < 1000) {
            return true;
        }
        lastClickTime = time;
        return false;
    }

    public static final boolean isChineseCharacter(String chineseStr) {
        char[] charArray = chineseStr.toCharArray();
        for (int i = 0; i < charArray.length; i++) {
            // 是否是Unicode编码,除了"�"这个字符.这个字符要另外处理
            if ((charArray[i] >= '\u0000' && charArray[i] < '\uFFFD')
                    || ((charArray[i] > '\uFFFD' && charArray[i] < '\uFFFF'))) {
                continue;
            } else {
                return false;
            }
        }
        return true;
    }

    /**
     * Get a file path from a Uri. This will get the the path for Storage Access
     * Framework Documents, as well as the _data field for the MediaStore and
     * other file-based ContentProviders.
     *
     * @param context The context.
     * @param uri     The Uri to query.
     * @author paulburke
     */
    @TargetApi(Build.VERSION_CODES.KITKAT)
    public static String getPath(final Context context, final Uri uri) {

        final boolean isKitKat = Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT;

        // DocumentProvider
        if (isKitKat && DocumentsContract.isDocumentUri(context, uri)) {
            // ExternalStorageProvider
            if (isExternalStorageDocument(uri)) {
                final String docId = DocumentsContract.getDocumentId(uri);
                final String[] split = docId.split(":");
                final String type = split[0];

                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/"
                            + split[1];
                }

            }
            // DownloadsProvider
            else if (isDownloadsDocument(uri)) {

                final String id = DocumentsContract.getDocumentId(uri);
                final Uri contentUri = ContentUris.withAppendedId(
                        Uri.parse("content://downloads/public_downloads"),
                        Long.valueOf(id));

                return getDataColumn(context, contentUri, null, null);
            }
            // MediaProvider
            else if (isMediaDocument(uri)) {
                final String docId = DocumentsContract.getDocumentId(uri);
                final String[] split = docId.split(":");
                final String type = split[0];

                Uri contentUri = null;
                if ("image".equals(type)) {
                    contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(type)) {
                    contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(type)) {
                    contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }

                final String selection = "_id=?";
                final String[] selectionArgs = new String[]{split[1]};

                return getDataColumn(context, contentUri, selection,
                        selectionArgs);
            }
        }
        // MediaStore (and general)
        else if ("content".equalsIgnoreCase(uri.getScheme())) {
            return getDataColumn(context, uri, null, null);
        }
        // File
        else if ("file".equalsIgnoreCase(uri.getScheme())) {
            return uri.getPath();
        }

        return null;
    }

    /**
     * Get the value of the data column for this Uri. This is useful for
     * MediaStore Uris, and other file-based ContentProviders.
     *
     * @param context       The context.
     * @param uri           The Uri to query.
     * @param selection     (Optional) Filter used in the query.
     * @param selectionArgs (Optional) Selection arguments used in the query.
     * @return The value of the _data column, which is typically a file path.
     */
    public static String getDataColumn(Context context, Uri uri,
                                       String selection, String[] selectionArgs) {

        Cursor cursor = null;
        final String column = "_data";
        final String[] projection = {column};

        try {
            cursor = context.getContentResolver().query(uri, projection,
                    selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                final int column_index = cursor.getColumnIndexOrThrow(column);
                return cursor.getString(column_index);
            }
        } finally {
            if (cursor != null)
                cursor.close();
        }
        return null;
    }

    /**
     * @param uri The Uri to check.
     * @return Whether the Uri authority is ExternalStorageProvider.
     */
    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri
                .getAuthority());
    }

    /**
     * @param uri The Uri to check.
     * @return Whether the Uri authority is DownloadsProvider.
     */
    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri
                .getAuthority());
    }

    /**
     * @param uri The Uri to check.
     * @return Whether the Uri authority is MediaProvider.
     */
    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri
                .getAuthority());
    }

    //获取屏幕的宽度
    public static int getScreenWidth(Context context) {
        WindowManager manager = (WindowManager) context
                .getSystemService(Context.WINDOW_SERVICE);
        Display display = manager.getDefaultDisplay();
        return display.getWidth();
    }

    //获取屏幕的高度
    public static int getScreenHeight(Context context) {
        WindowManager manager = (WindowManager) context
                .getSystemService(Context.WINDOW_SERVICE);
        Display display = manager.getDefaultDisplay();
        return display.getHeight();
    }

    //文字末尾加图标
    public static CharSequence textValueOf(int resImgId, String text) {
        //@drawable/xinshi_zhiding置顶图标
        String html = text + " <img src='%1$s'>";
        html = String.format(html, resImgId);
        CharSequence charSequence = Html.fromHtml(html, new Html.ImageGetter() {

            @Override
            public Drawable getDrawable(String source) {
                int id = Integer.valueOf(source);

                Drawable drawable = BaseApp.Companion.getApp().getResources().getDrawable(id);
                //手动生成Drawable的时候 ，一般都要setBounds一下， 不然有时候会报错，记住就行了，
                drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
                return drawable;
            }
        }, null);

        return charSequence;
    }

    //文字前面加图标
    public static CharSequence textValueOfStart(int resImgId, String text) {

        text = "   " + text;

        Drawable drawable = BaseApp.Companion.getApp().getResources().getDrawable(resImgId);
//                //手动生成Drawable的时候 ，一般都要setBounds一下， 不然有时候会报错，记住就行了，
        drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());

        CenterAlignImageSpan span = new CenterAlignImageSpan(drawable);
        SpannableString spanStr = new SpannableString(text);
        spanStr.setSpan(span, 0, 1, ImageSpan.ALIGN_BASELINE);


        return spanStr;

    }

    //部分文字颜色转换
    public static CharSequence textColorValurOf(String text, String keyWords) {
        int redIndex = text.indexOf(keyWords);
        SpannableStringBuilder ssb = new SpannableStringBuilder(text);
        ForegroundColorSpan fcs = new ForegroundColorSpan(0xFF3fca6a);
        ssb.setSpan(fcs, redIndex, redIndex + keyWords.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        return ssb;
    }

    /**
     * 将TextView中带中括号的字体高亮
     *
     * @param tvFansDesc
     * @param discountText
     * @param foregroundColor
     * @param textColor
     */
    public static void setTextSpan(TextView tvFansDesc, String discountText, String foregroundColor, String textColor) {
        String textContent = discountText.replace("[", "");
        textContent = textContent.replace("]", "");
        tvFansDesc.setText(textContent);

        SpannableStringBuilder builder = new SpannableStringBuilder(textContent);

        List<String> mHiehLight = getSpliteText(discountText);

        for (String heigh : mHiehLight) {
            int index = discountText.indexOf("[" + heigh + "]");
            int endIndex = index + heigh.length();
            discountText = discountText.replace("[" + heigh + "]", heigh);
            if (!TextUtils.isEmpty(foregroundColor) && textColor.length() == 6)
                builder.setSpan(new ForegroundColorSpan(Color.parseColor("#" + foregroundColor)), index, endIndex, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
        }
        if (!TextUtils.isEmpty(textColor) && textColor.length() == 6)
            tvFansDesc.setTextColor(Color.parseColor("#" + textColor));

        if (mHiehLight.size() > 0) {
            tvFansDesc.setText(builder);
        }
    }

    /**
     * 替换左右标识字符
     *
     * @param text
     * @return
     */
    private static List<String> getSpliteText(String text) {
        List<String> mList = new ArrayList<>();
        text = text.replace("[", "(left)");
        text = text.replace("]", "(right)");
        if (!TextUtils.isEmpty(text) && text.contains("(left)") && text.contains("(right)")) {
            String spli = "";
            String[] strings = text.split("(left)");
            if (null != strings && strings.length > 1) {
                for (int i = 1; i < strings.length; i++) {
                    String result = strings[i].split("(right)")[0];
                    if (result.contains("(")) {
                        result = result.replace("(", "");
                    }
                    if (result.contains(")")) {
                        result = result.replace(")", "");
                    }
                    mList.add(result);
                }
            }
        }
        return mList;
    }

    public static void closeAndroidPDialog() {
        try {
            Class aClass = Class.forName("android.content.pm.PackageParser$Package");
            Constructor declaredConstructor = aClass.getDeclaredConstructor(String.class);
            declaredConstructor.setAccessible(true);
        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Class cls = Class.forName("android.app.ActivityThread");
            Method declaredMethod = cls.getDeclaredMethod("currentActivityThread");
            declaredMethod.setAccessible(true);
            Object activityThread = declaredMethod.invoke(null);
            Field mHiddenApiWarningShown = cls.getDeclaredField("mHiddenApiWarningShown");
            mHiddenApiWarningShown.setAccessible(true);
            mHiddenApiWarningShown.setBoolean(activityThread, true);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取当前对象【fieldName】属性的值
     *
     * @param obj       对象
     * @param fieldName 属性名
     * @return
     * @throws Exception
     */
    public static Object getValue(Object obj, String fieldName) throws Exception {
        if (obj == null || StringUtils.isEmpty(fieldName)) return null;
        // 获取对象的属性
        Field field = obj.getClass().getDeclaredField(fieldName);
        // 对象的属性的访问权限设置为可访问
        field.setAccessible(true);
        // 返回此属性的值
        return field.get(obj);
    }
}
